/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.repository.query.EvaluationContextProvider;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, EvaluationContextProvider evaluationContextProvider) {
        this(method, em, method.getAnnotatedQuery(), evaluationContextProvider);
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider) {
        super(method, em, queryString, evaluationContextProvider);
        this.validateQuery(this.getQuery().getQueryString(), String.format("Validation failed for query for method %s!", new Object[]{method}));
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s!", new Object[]{method}));
        }
    }

    private final void validateQuery(String query, String errorMessage) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        EntityManager validatingEm = null;
        try {
            validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
        finally {
            if (validatingEm != null) {
                validatingEm.close();
            }
        }
    }
}

