/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class HiveScript {
    private Resource resource;
    private Map<String, String> arguments;

    public HiveScript(Resource resource) {
        this(resource, (Map)null);
    }

    public HiveScript(Resource resource, Map<?, ?> args) {
        Assert.notNull((Object)resource, (String)"a valid resource is required");
        this.resource = resource;
        if (args != null) {
            this.arguments = new LinkedHashMap<String, String>();
            for (Map.Entry<?, ?> entry : args.entrySet()) {
                this.arguments.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
    }

    public HiveScript(Resource resource, Properties args) {
        Assert.notNull((Object)resource, (String)"a valid resource is required");
        this.resource = resource;
        if (args != null) {
            Set<String> props = args.stringPropertyNames();
            this.arguments = new LinkedHashMap<String, String>();
            for (String prop : props) {
                this.arguments.put(prop, args.getProperty(prop));
            }
        }
    }

    public Resource getResource() {
        return this.resource;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return this.resource.getDescription();
    }
}

