/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.common.annotation.configuration;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.hadoop.config.common.annotation.ObjectPostProcessor;
import org.springframework.util.Assert;

final class AutowireBeanFactoryObjectPostProcessor
implements ObjectPostProcessor<Object>,
DisposableBean,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(AutowireBeanFactoryObjectPostProcessor.class);
    private final AutowireCapableBeanFactory autowireBeanFactory;
    private final List<DisposableBean> disposableBeans = new ArrayList<DisposableBean>();
    private final List<Lifecycle> lifecycleBeans = new ArrayList<Lifecycle>();
    private boolean running;

    public AutowireBeanFactoryObjectPostProcessor(AutowireCapableBeanFactory autowireBeanFactory) {
        Assert.notNull((Object)autowireBeanFactory, (String)"autowireBeanFactory cannot be null");
        this.autowireBeanFactory = autowireBeanFactory;
    }

    @Override
    public <T> T postProcess(T object) {
        Object result = this.autowireBeanFactory.initializeBean(object, null);
        if (result instanceof DisposableBean) {
            this.disposableBeans.add((DisposableBean)result);
        }
        if (result instanceof Lifecycle) {
            this.lifecycleBeans.add((Lifecycle)result);
        }
        return (T)result;
    }

    public void destroy() throws Exception {
        for (DisposableBean disposable : this.disposableBeans) {
            try {
                disposable.destroy();
            }
            catch (Exception error) {
                log.error((Object)error);
            }
        }
    }

    public void start() {
        this.running = true;
        for (Lifecycle bean : this.lifecycleBeans) {
            bean.start();
        }
    }

    public void stop() {
        for (Lifecycle bean : this.lifecycleBeans) {
            bean.stop();
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

