/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.Collections;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactorySupport;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MappingContextIsNewStrategyFactory
extends IsNewStrategyFactorySupport {
    private final PersistentEntities context;

    @Deprecated
    public MappingContextIsNewStrategyFactory(MappingContext<? extends PersistentEntity<?, ?>, ?> context) {
        this(new PersistentEntities(Collections.singletonList(context)));
    }

    public MappingContextIsNewStrategyFactory(PersistentEntities entities) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        this.context = entities;
    }

    @Override
    @Nullable
    protected IsNewStrategy doGetIsNewStrategy(Class<?> type) {
        PersistentEntity<?, PersistentProperty<?>> entity = this.context.getRequiredPersistentEntity(type);
        if (entity.hasVersionProperty()) {
            return PersistentPropertyInspectingIsNewStrategy.of(entity.getRequiredVersionProperty(), MappingContextIsNewStrategyFactory::propertyIsNullOrZeroNumber);
        }
        if (entity.hasIdProperty()) {
            return PersistentPropertyInspectingIsNewStrategy.of(entity.getRequiredIdProperty(), MappingContextIsNewStrategyFactory::propertyIsNullOrZeroNumber);
        }
        return null;
    }

    private static boolean propertyIsNullOrZeroNumber(Object value) {
        return value == null || value instanceof Number && ((Number)value).longValue() == 0L;
    }

    static class PersistentPropertyInspectingIsNewStrategy
    implements IsNewStrategy {
        @NonNull
        private final PersistentProperty<?> property;
        @NonNull
        private final Function<Object, Boolean> isNew;

        @Override
        public boolean isNew(Object entity) {
            Assert.notNull((Object)entity, (String)"Entity must not be null!");
            return this.isNew.apply(this.property.getOwner().getPropertyAccessor(entity).getProperty(this.property));
        }

        @Generated
        private PersistentPropertyInspectingIsNewStrategy(@NonNull PersistentProperty<?> property, @NonNull Function<Object, Boolean> isNew) {
            if (property == null) {
                throw new IllegalArgumentException("property is marked @NonNull but is null");
            }
            if (isNew == null) {
                throw new IllegalArgumentException("isNew is marked @NonNull but is null");
            }
            this.property = property;
            this.isNew = isNew;
        }

        @Generated
        public static PersistentPropertyInspectingIsNewStrategy of(@NonNull PersistentProperty<?> property, @NonNull Function<Object, Boolean> isNew) {
            return new PersistentPropertyInspectingIsNewStrategy(property, isNew);
        }
    }
}

