/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ZookeeperHealthIndicator
extends AbstractHealthIndicator {
    private final CuratorFramework curator;

    public ZookeeperHealthIndicator(CuratorFramework curator) {
        this.curator = curator;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            if (this.curator.getState() != CuratorFrameworkState.STARTED) {
                builder.down().withDetail("error", (Object)"Client not started");
            } else if (this.curator.checkExists().forPath("/") == null) {
                builder.down().withDetail("error", (Object)"Root for namespace does not exist");
            } else {
                builder.up();
            }
            builder.withDetail("connectionString", (Object)this.curator.getZookeeperClient().getCurrentConnectionString()).withDetail("state", (Object)this.curator.getState());
        }
        catch (Exception e) {
            builder.down(e);
        }
    }
}

