/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.ZookeeperHealthIndicator;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnZookeeperEnabled
@EnableConfigurationProperties
public class ZookeeperAutoConfiguration {
    private static final Log log = LogFactory.getLog(ZookeeperAutoConfiguration.class);
    @Autowired(required=false)
    private EnsembleProvider ensembleProvider;

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperProperties zookeeperProperties() {
        return new ZookeeperProperties();
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(RetryPolicy retryPolicy, ZookeeperProperties properties) throws Exception {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (this.ensembleProvider != null) {
            builder.ensembleProvider(this.ensembleProvider);
        } else {
            builder.connectString(properties.getConnectString());
        }
        CuratorFramework curator = builder.retryPolicy(retryPolicy).build();
        curator.start();
        log.trace((Object)("blocking until connected to zookeeper for " + properties.getBlockUntilConnectedWait() + (Object)((Object)properties.getBlockUntilConnectedUnit())));
        curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
        log.trace((Object)"connected to zookeeper");
        return curator;
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy exponentialBackoffRetry(ZookeeperProperties properties) {
        return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class ZookeeperHealthConfig {
        protected ZookeeperHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledHealthIndicator(value="zookeeper")
        public ZookeeperHealthIndicator zookeeperHealthIndicator(CuratorFramework curator) {
            return new ZookeeperHealthIndicator(curator);
        }
    }
}

