/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.springframework.cloud.util.UriInfo;
import org.springframework.cloud.util.UriInfoFactory;

public class StandardUriInfoFactory
implements UriInfoFactory {
    public static final String JDBC_PREFIX = "jdbc:";

    @Override
    public UriInfo createUri(String scheme, String host, int port, String username, String password, String path) {
        return new UriInfo(scheme, host, port, username, password, path);
    }

    @Override
    public UriInfo createUri(String uriString) {
        uriString = this.trimJdbcScheme(uriString);
        URI tmpUri = this.createTmpUri(uriString);
        String[] userInfo = this.parseUserinfo(tmpUri);
        String userName = StandardUriInfoFactory.uriDecode(userInfo[0]);
        String password = StandardUriInfoFactory.uriDecode(userInfo[1]);
        return new UriInfo(tmpUri.getScheme(), tmpUri.getHost(), tmpUri.getPort(), userName, password, this.parsePath(tmpUri), tmpUri.getRawQuery(), uriString);
    }

    private URI createTmpUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String trimJdbcScheme(String uriString) {
        if (uriString.startsWith(JDBC_PREFIX)) {
            uriString = uriString.substring(JDBC_PREFIX.length());
        }
        return uriString;
    }

    private String[] parseUserinfo(URI uri) {
        String userInfo = uri.getRawUserInfo();
        if (userInfo != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length != 2) {
                throw new IllegalArgumentException("Bad userinfo in URI: " + uri);
            }
            return userPass;
        }
        return new String[]{null, null};
    }

    private String parsePath(URI uri) {
        String rawPath = uri.getRawPath();
        if (rawPath != null && rawPath.length() > 1) {
            return rawPath.substring(1);
        }
        return null;
    }

    private static String uriDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

