/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.common;

import org.springframework.cloud.CloudException;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.cloud.util.UriInfo;

@ServiceInfo.ServiceLabel(value="rabbitmq")
public class AmqpServiceInfo
extends UriBasedServiceInfo {
    public static final String AMQP_SCHEME = "amqp";
    public static final String AMQPS_SCHEME = "amqps";

    public AmqpServiceInfo(String id, String host, int port, String username, String password, String virtualHost) {
        super(id, AMQP_SCHEME, host, port, username, password, virtualHost);
    }

    public AmqpServiceInfo(String id, String uri) throws CloudException {
        super(id, uri);
    }

    @ServiceInfo.ServiceProperty(category="connection")
    public String getVirtualHost() {
        return this.getUriInfo().getPath();
    }

    @Override
    protected UriInfo validateAndCleanUriInfo(UriInfo uriInfo) {
        if (uriInfo.getScheme() == null) {
            throw new IllegalArgumentException("Missing scheme in amqp URI: " + uriInfo);
        }
        if (uriInfo.getHost() == null) {
            throw new IllegalArgumentException("Missing authority in amqp URI: " + uriInfo);
        }
        if (uriInfo.getUserName() == null || uriInfo.getPassword() == null) {
            throw new IllegalArgumentException("Missing userinfo in amqp URI: " + uriInfo);
        }
        String path = uriInfo.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Missing virtual host in amqp URI: " + uriInfo);
        }
        if (path.indexOf(47) != -1) {
            throw new IllegalArgumentException("Multiple segments in path of amqp URI: " + uriInfo);
        }
        return uriInfo;
    }
}

