/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.FallbackServiceInfoCreator;
import org.springframework.cloud.ServiceInfoCreator;
import org.springframework.cloud.service.ServiceInfo;

public abstract class AbstractCloudConnector<SD>
implements CloudConnector {
    private static Logger logger = Logger.getLogger(AbstractCloudConnector.class.getName());
    protected List<ServiceInfoCreator<?, SD>> serviceInfoCreators = new ArrayList();

    protected abstract List<SD> getServicesData();

    protected abstract FallbackServiceInfoCreator<?, SD> getFallbackServiceInfoCreator();

    public AbstractCloudConnector(Class<? extends ServiceInfoCreator<? extends ServiceInfo, ?>> serviceInfoCreatorClass) {
        this.scanServiceInfoCreators(serviceInfoCreatorClass);
    }

    @Override
    public List<ServiceInfo> getServiceInfos() {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (SD serviceData : this.getServicesData()) {
            serviceInfos.add(this.getServiceInfo(serviceData));
        }
        return serviceInfos;
    }

    protected void registerServiceInfoCreator(ServiceInfoCreator<? extends ServiceInfo, SD> serviceInfoCreator) {
        this.serviceInfoCreators.add(serviceInfoCreator);
    }

    private void scanServiceInfoCreators(Class<? extends ServiceInfoCreator<? extends ServiceInfo, ?>> serviceInfoCreatorClass) {
        ServiceLoader<ServiceInfoCreator<ServiceInfo, ?>> serviceInfoCreators = ServiceLoader.load(serviceInfoCreatorClass);
        for (ServiceInfoCreator<? extends ServiceInfo, ?> serviceInfoCreator : serviceInfoCreators) {
            this.registerServiceInfoCreator(serviceInfoCreator);
        }
    }

    private ServiceInfo getServiceInfo(SD serviceData) {
        for (ServiceInfoCreator<?, SD> serviceInfoCreator : this.serviceInfoCreators) {
            if (!serviceInfoCreator.accept(serviceData)) continue;
            return serviceInfoCreator.createServiceInfo(serviceData);
        }
        Object fallackServiceInfo = this.getFallbackServiceInfoCreator().createServiceInfo(serviceData);
        logger.warning("No suitable service info creator found for service " + fallackServiceInfo.getId() + " Did you forget to add a ServiceInfoCreator?");
        return fallackServiceInfo;
    }
}

