/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template.web;

import groovy.text.Template;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class GroovyTemplateView
extends AbstractUrlBasedView {
    private final Template template;

    public GroovyTemplateView(Template template) {
        this.template = template;
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.applyContentType(response);
        model.put("spring", new RequestContext(request, response, this.getServletContext(), model));
        this.template.make(model).writeTo((Writer)new BufferedWriter(response.getWriter()));
    }

    protected void applyContentType(HttpServletResponse response) {
        if (response.getContentType() == null) {
            response.setContentType(this.getContentType());
        }
    }
}

