/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.LiveBeansView;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.beans")
public class BeansEndpoint
extends AbstractEndpoint<List<Object>>
implements ApplicationContextAware {
    private final HierarchyAwareLiveBeansView liveBeansView = new HierarchyAwareLiveBeansView();
    private final JsonParser parser = JsonParserFactory.getJsonParser();

    public BeansEndpoint() {
        super("beans");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (context.getEnvironment().getProperty("spring.liveBeansView.mbeanDomain") == null) {
            this.liveBeansView.setLeafContext(context);
        }
    }

    @Override
    public List<Object> invoke() {
        return this.parser.parseList(this.liveBeansView.getSnapshotAsJson());
    }

    private static class HierarchyAwareLiveBeansView
    extends LiveBeansView {
        private ConfigurableApplicationContext leafContext;

        private HierarchyAwareLiveBeansView() {
        }

        private void setLeafContext(ApplicationContext leafContext) {
            this.leafContext = this.asConfigurableContext(leafContext);
        }

        public String getSnapshotAsJson() {
            if (this.leafContext == null) {
                return super.getSnapshotAsJson();
            }
            return this.generateJson(this.getContextHierarchy());
        }

        private ConfigurableApplicationContext asConfigurableContext(ApplicationContext applicationContext) {
            Assert.isTrue((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)("'" + applicationContext + "' does not implement ConfigurableApplicationContext"));
            return (ConfigurableApplicationContext)applicationContext;
        }

        private Set<ConfigurableApplicationContext> getContextHierarchy() {
            LinkedHashSet<ConfigurableApplicationContext> contexts = new LinkedHashSet<ConfigurableApplicationContext>();
            for (ConfigurableApplicationContext context = this.leafContext; context != null; context = context.getParent()) {
                contexts.add(this.asConfigurableContext((ApplicationContext)context));
            }
            return contexts;
        }
    }
}

