/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import liquibase.integration.spring.SpringLiquibase;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.AutoConfigurationReportEndpoint;
import org.springframework.boot.actuate.endpoint.BeansEndpoint;
import org.springframework.boot.actuate.endpoint.ConfigurationPropertiesReportEndpoint;
import org.springframework.boot.actuate.endpoint.DumpEndpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.FlywayEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.InfoEndpoint;
import org.springframework.boot.actuate.endpoint.LiquibaseEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.endpoint.RequestMappingEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.TraceEndpoint;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.trace.InMemoryTraceRepository;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;

@Configuration
@AutoConfigureAfter(value={FlywayAutoConfiguration.class, LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(value={EndpointProperties.class})
public class EndpointAutoConfiguration {
    @Autowired
    private InfoPropertiesConfiguration properties;
    @Autowired(required=false)
    private HealthAggregator healthAggregator = new OrderedHealthAggregator();
    @Autowired(required=false)
    private Map<String, HealthIndicator> healthIndicators = new HashMap<String, HealthIndicator>();
    @Autowired(required=false)
    private Collection<PublicMetrics> publicMetrics;
    @Autowired(required=false)
    private TraceRepository traceRepository = new InMemoryTraceRepository();

    @Bean
    @ConditionalOnMissingBean
    public EnvironmentEndpoint environmentEndpoint() {
        return new EnvironmentEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthEndpoint healthEndpoint() {
        return new HealthEndpoint(this.healthAggregator, this.healthIndicators);
    }

    @Bean
    @ConditionalOnMissingBean
    public BeansEndpoint beansEndpoint() {
        return new BeansEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public InfoEndpoint infoEndpoint() throws Exception {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.putAll(this.properties.infoMap());
        GitInfo gitInfo = this.properties.gitInfo();
        if (gitInfo.getBranch() != null) {
            info.put("git", gitInfo);
        }
        return new InfoEndpoint(info);
    }

    @Bean
    @ConditionalOnMissingBean
    public MetricsEndpoint metricsEndpoint() {
        ArrayList<PublicMetrics> publicMetrics = new ArrayList<PublicMetrics>();
        if (this.publicMetrics != null) {
            publicMetrics.addAll(this.publicMetrics);
        }
        Collections.sort(publicMetrics, AnnotationAwareOrderComparator.INSTANCE);
        return new MetricsEndpoint(publicMetrics);
    }

    @Bean
    @ConditionalOnMissingBean
    public TraceEndpoint traceEndpoint() {
        return new TraceEndpoint(this.traceRepository);
    }

    @Bean
    @ConditionalOnMissingBean
    public DumpEndpoint dumpEndpoint() {
        return new DumpEndpoint();
    }

    @Bean
    @ConditionalOnBean(value={ConditionEvaluationReport.class})
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public AutoConfigurationReportEndpoint autoConfigurationReportEndpoint() {
        return new AutoConfigurationReportEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public ShutdownEndpoint shutdownEndpoint() {
        return new ShutdownEndpoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationPropertiesReportEndpoint configurationPropertiesReportEndpoint() {
        return new ConfigurationPropertiesReportEndpoint();
    }

    public static class GitInfo {
        private String branch;
        private final Commit commit = new Commit();

        public String getBranch() {
            return this.branch;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public Commit getCommit() {
            return this.commit;
        }

        public static class Commit {
            private String id;
            private String time;

            public String getId() {
                return this.id == null ? "" : (this.id.length() > 7 ? this.id.substring(0, 7) : this.id);
            }

            public void setId(String id) {
                this.id = id;
            }

            public String getTime() {
                return this.time;
            }

            public void setTime(String time) {
                this.time = time;
            }
        }
    }

    @Configuration
    protected static class InfoPropertiesConfiguration {
        @Autowired
        private final ConfigurableEnvironment environment = new StandardEnvironment();
        @Value(value="${spring.git.properties:classpath:git.properties}")
        private Resource gitProperties;

        protected InfoPropertiesConfiguration() {
        }

        public GitInfo gitInfo() throws Exception {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory((Object)new GitInfo());
            factory.setTargetName("git");
            Properties properties = new Properties();
            if (this.gitProperties.exists()) {
                properties = PropertiesLoaderUtils.loadProperties((Resource)this.gitProperties);
            }
            factory.setProperties(properties);
            return (GitInfo)factory.getObject();
        }

        public Map<String, Object> infoMap() throws Exception {
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory(new LinkedHashMap());
            factory.setTargetName("info");
            factory.setPropertySources((PropertySources)this.environment.getPropertySources());
            return (Map)factory.getObject();
        }
    }

    @Configuration
    @ConditionalOnClass(value={AbstractHandlerMethodMapping.class})
    protected static class RequestMappingEndpointConfiguration {
        protected RequestMappingEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RequestMappingEndpoint requestMappingEndpoint() {
            RequestMappingEndpoint endpoint = new RequestMappingEndpoint();
            return endpoint;
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=SpringLiquibase.class)
    @ConditionalOnClass(value={SpringLiquibase.class})
    static class LiquibaseEndpointConfiguration {
        LiquibaseEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LiquibaseEndpoint liquibaseEndpoint(SpringLiquibase liquibase) {
            return new LiquibaseEndpoint(liquibase);
        }
    }

    @Configuration
    @ConditionalOnSingleCandidate(value=Flyway.class)
    @ConditionalOnClass(value={Flyway.class})
    static class FlywayEndpointConfiguration {
        FlywayEndpointConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayEndpoint flywayEndpoint(Flyway flyway) {
            return new FlywayEndpoint(flyway);
        }
    }
}

