/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSourceHealthIndicator
extends AbstractHealthIndicator
implements InitializingBean {
    private static final String DEFAULT_QUERY = "SELECT 1";
    private DataSource dataSource;
    private String query;
    private JdbcTemplate jdbcTemplate;

    public DataSourceHealthIndicator() {
    }

    public DataSourceHealthIndicator(DataSource dataSource) {
        this(dataSource, null);
    }

    public DataSourceHealthIndicator(DataSource dataSource, String query) {
        this.dataSource = dataSource;
        this.query = query;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource for DataSourceHealthIndicator must be specified");
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.dataSource == null) {
            builder.up().withDetail("database", "unknown");
        } else {
            this.doDataSourceHealthCheck(builder);
        }
    }

    private void doDataSourceHealthCheck(Health.Builder builder) throws Exception {
        String product = this.getProduct();
        builder.up().withDetail("database", product);
        String validationQuery = this.getValidationQuery(product);
        if (StringUtils.hasText((String)validationQuery)) {
            try {
                List results = this.jdbcTemplate.query(validationQuery, (RowMapper)new SingleColumnRowMapper());
                Object result = DataAccessUtils.requiredSingleResult((Collection)results);
                builder.withDetail("hello", result);
            }
            catch (Exception ex) {
                builder.down(ex);
            }
        }
    }

    private String getProduct() {
        return (String)this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getDatabaseProductName();
            }
        });
    }

    protected String getValidationQuery(String product) {
        Product specific;
        String query = this.query;
        if (!StringUtils.hasText((String)query) && (specific = Product.forProduct(product)) != null) {
            query = specific.getQuery();
        }
        if (!StringUtils.hasText((String)query)) {
            query = DEFAULT_QUERY;
        }
        return query;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    protected static enum Product {
        HSQLDB("HSQL Database Engine", "SELECT COUNT(*) FROM INFORMATION_SCHEMA.SYSTEM_USERS"),
        ORACLE("Oracle", "SELECT 'Hello' from DUAL"),
        DERBY("Apache Derby", "SELECT 1 FROM SYSIBM.SYSDUMMY1"),
        DB2("DB2", "SELECT 1 FROM SYSIBM.SYSDUMMY1"){

            @Override
            protected boolean matchesProduct(String product) {
                return super.matchesProduct(product) || product.toLowerCase().startsWith("db2/");
            }
        }
        ,
        DB2_AS400("DB2 UDB for AS/400", "SELECT 1 FROM SYSIBM.SYSDUMMY1"){

            @Override
            protected boolean matchesProduct(String product) {
                return super.matchesProduct(product) || product.toLowerCase().contains("as/400");
            }
        }
        ,
        INFORMIX("Informix Dynamic Server", "select count(*) from systables"),
        FIREBIRD("Firebird", "SELECT 1 FROM RDB$DATABASE"){

            @Override
            protected boolean matchesProduct(String product) {
                return super.matchesProduct(product) || product.toLowerCase().startsWith("firebird");
            }
        };

        private final String product;
        private final String query;

        private Product(String product, String query) {
            this.product = product;
            this.query = query;
        }

        protected boolean matchesProduct(String product) {
            return this.product.equalsIgnoreCase(product);
        }

        public String getQuery() {
            return this.query;
        }

        public static Product forProduct(String product) {
            for (Product candidate : Product.values()) {
                if (!candidate.matchesProduct(product)) continue;
                return candidate;
            }
            return null;
        }
    }

    private static class SingleColumnRowMapper
    implements RowMapper<Object> {
        private SingleColumnRowMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            ResultSetMetaData metaData = rs.getMetaData();
            int columns = metaData.getColumnCount();
            if (columns != 1) {
                throw new IncorrectResultSetColumnCountException(1, columns);
            }
            return JdbcUtils.getResultSetValue((ResultSet)rs, (int)1);
        }
    }
}

