/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.audit;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;

public class InMemoryAuditEventRepository
implements AuditEventRepository {
    private static final int DEFAULT_CAPACITY = 4000;
    private AuditEvent[] events;
    private volatile int tail = -1;

    public InMemoryAuditEventRepository() {
        this(4000);
    }

    public InMemoryAuditEventRepository(int capacity) {
        this.events = new AuditEvent[capacity];
    }

    public synchronized void setCapacity(int capacity) {
        this.events = new AuditEvent[capacity];
    }

    @Override
    public synchronized List<AuditEvent> find(String principal, Date after) {
        int index;
        AuditEvent event;
        LinkedList<AuditEvent> events = new LinkedList<AuditEvent>();
        for (int i = 0; i < this.events.length && (event = this.events[index = (this.tail + this.events.length - i) % this.events.length]) != null; ++i) {
            if (!this.isMatch(event, principal, after)) continue;
            events.addFirst(event);
        }
        return events;
    }

    private boolean isMatch(AuditEvent auditEvent, String principal, Date after) {
        return !(principal != null && !auditEvent.getPrincipal().equals(principal) || after != null && auditEvent.getTimestamp().compareTo(after) < 0);
    }

    @Override
    public synchronized void add(AuditEvent event) {
        this.tail = (this.tail + 1) % this.events.length;
        this.events[this.tail] = event;
    }
}

