/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.audit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationListener;

public class AuditListener
implements ApplicationListener<AuditApplicationEvent> {
    private static Log logger = LogFactory.getLog(AuditListener.class);
    private final AuditEventRepository auditEventRepository;

    public AuditListener(AuditEventRepository auditEventRepository) {
        this.auditEventRepository = auditEventRepository;
    }

    public void onApplicationEvent(AuditApplicationEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)event.getAuditEvent());
        }
        this.auditEventRepository.add(event.getAuditEvent());
    }
}

