/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class HealthMvcEndpoint
implements MvcEndpoint {
    private Map<String, HttpStatus> statusMapping = new HashMap<String, HttpStatus>();
    private HealthEndpoint delegate;
    private long lastAccess = 0L;
    private Health cached;

    public HealthMvcEndpoint(HealthEndpoint delegate) {
        this.delegate = delegate;
        this.setupDefaultStatusMapping();
    }

    private void setupDefaultStatusMapping() {
        this.addStatusMapping(Status.DOWN, HttpStatus.SERVICE_UNAVAILABLE);
        this.addStatusMapping(Status.OUT_OF_SERVICE, HttpStatus.SERVICE_UNAVAILABLE);
    }

    public void setStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping = new HashMap<String, HttpStatus>(statusMapping);
    }

    public void addStatusMapping(Map<String, HttpStatus> statusMapping) {
        Assert.notNull(statusMapping, (String)"StatusMapping must not be null");
        this.statusMapping.putAll(statusMapping);
    }

    public void addStatusMapping(Status status, HttpStatus httpStatus) {
        Assert.notNull((Object)status, (String)"Status must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.addStatusMapping(status.getCode(), httpStatus);
    }

    public void addStatusMapping(String statusCode, HttpStatus httpStatus) {
        Assert.notNull((Object)statusCode, (String)"StatusCode must not be null");
        Assert.notNull((Object)httpStatus, (String)"HttpStatus must not be null");
        this.statusMapping.put(statusCode, httpStatus);
    }

    @RequestMapping
    @ResponseBody
    public Object invoke(Principal principal) {
        if (!this.delegate.isEnabled()) {
            return new ResponseEntity(Collections.singletonMap("message", "This endpoint is disabled"), HttpStatus.NOT_FOUND);
        }
        Health health = this.getHealth(principal);
        Status status = health.getStatus();
        if (this.statusMapping.containsKey(status.getCode())) {
            return new ResponseEntity((Object)health, this.statusMapping.get(status.getCode()));
        }
        return health;
    }

    private Health getHealth(Principal principal) {
        Health health;
        this.cached = health = this.useCachedValue(principal) ? this.cached : this.delegate.invoke();
        if (!this.secure(principal) && this.delegate.isSensitive()) {
            health = Health.status(health.getStatus()).build();
        }
        return health;
    }

    private boolean secure(Principal principal) {
        return principal != null && !principal.getClass().getName().contains("Anonymous");
    }

    private boolean useCachedValue(Principal principal) {
        long accessTime = System.currentTimeMillis();
        if (this.cacheIsStale(accessTime) || this.secure(principal) || !this.delegate.isSensitive()) {
            this.lastAccess = accessTime;
            return false;
        }
        return this.cached != null;
    }

    private boolean cacheIsStale(long accessTime) {
        return this.cached == null || accessTime - this.lastAccess > this.delegate.getTimeToLive();
    }

    @Override
    public String getPath() {
        return "/" + this.delegate.getId();
    }

    @Override
    public boolean isSensitive() {
        return this.delegate.isSensitive();
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return this.delegate.getClass();
    }
}

