/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementSecurityAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMappingCustomizer;
import org.springframework.boot.actuate.endpoint.mvc.ManagementErrorEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
public class EndpointWebMvcChildContextConfiguration {
    private static Log logger = LogFactory.getLog(EndpointWebMvcChildContextConfiguration.class);
    @Value(value="${error.path:/error}")
    private String errorPath = "/error";
    @Autowired(required=false)
    private List<EndpointHandlerMappingCustomizer> mappingCustomizers;

    @Bean
    public DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean
    public HandlerAdapter handlerAdapter(HttpMessageConverters converters) {
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();
        adapter.setMessageConverters(converters.getConverters());
        return adapter;
    }

    @Bean
    public HandlerMapping handlerMapping(MvcEndpoints endpoints, ListableBeanFactory beanFactory) {
        HashSet<? extends MvcEndpoint> set = new HashSet<MvcEndpoint>(endpoints.getEndpoints());
        set.addAll(beanFactory.getBeansOfType(MvcEndpoint.class).values());
        EndpointHandlerMapping mapping = new EndpointHandlerMapping(set);
        mapping.setDetectHandlerMethodsInAncestorContexts(true);
        this.injectIntoSecurityFilter(beanFactory, mapping);
        if (this.mappingCustomizers != null) {
            for (EndpointHandlerMappingCustomizer customizer : this.mappingCustomizers) {
                customizer.customize(mapping);
            }
        }
        return mapping;
    }

    private void injectIntoSecurityFilter(ListableBeanFactory beanFactory, EndpointHandlerMapping mapping) {
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ManagementSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class).length == 1) {
            ManagementSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter bean = (ManagementSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter)((Object)beanFactory.getBean(ManagementSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class));
            bean.setEndpointHandlerMapping(mapping);
        } else {
            logger.warn((Object)("No single bean of type " + ManagementSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class.getSimpleName() + " found (this might make some endpoints inaccessible without authentication)"));
        }
    }

    @Bean
    public ManagementErrorEndpoint errorEndpoint(ErrorAttributes errorAttributes) {
        return new ManagementErrorEndpoint(this.errorPath, errorAttributes);
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.PARENTS)
    public static class EndpointWebMvcChildContextSecurityConfiguration {
        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }

    @Configuration
    protected static class ServerCustomization
    implements EmbeddedServletContainerCustomizer {
        @Value(value="${error.path:/error}")
        private String errorPath = "/error";
        @Autowired
        private ListableBeanFactory beanFactory;
        private ManagementServerProperties managementServerProperties;
        private ServerProperties server;

        protected ServerCustomization() {
        }

        public void customize(ConfigurableEmbeddedServletContainer container) {
            if (this.managementServerProperties == null) {
                this.managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
                this.server = (ServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerProperties.class);
            }
            this.server.customize(container);
            container.setErrorPages(Collections.emptySet());
            container.setPort(this.managementServerProperties.getPort().intValue());
            container.setAddress(this.managementServerProperties.getAddress());
            container.setContextPath(this.managementServerProperties.getContextPath());
            container.addErrorPages(new ErrorPage[]{new ErrorPage(this.errorPath)});
        }
    }
}

