/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ansi.AnsiBackground;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiColors;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class ImageBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ImageBanner.class);
    private static final double[] RGB_WEIGHT = new double[]{0.2126, 0.7152, 0.0722};
    private static final char[] PIXEL = new char[]{' ', '.', '*', ':', 'o', '&', '8', '#', '@'};
    private static final int LUMINANCE_INCREMENT = 10;
    private static final int LUMINANCE_START = 10 * PIXEL.length;
    private final Resource image;

    public ImageBanner(Resource image) {
        Assert.notNull((Object)image, (String)"Image must not be null");
        Assert.isTrue((boolean)image.exists(), (String)"Image must exist");
        this.image = image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printBanner(Environment environment, Class<?> sourceClass, PrintStream out) {
        String headless = System.getProperty("java.awt.headless");
        try {
            System.setProperty("java.awt.headless", "true");
            this.printBanner(environment, out);
        }
        catch (Throwable ex) {
            logger.warn((Object)("Image banner not printable: " + this.image + " (" + ex.getClass() + ": '" + ex.getMessage() + "')"));
            logger.debug((Object)"Image banner printing failure", ex);
        }
        finally {
            if (headless == null) {
                System.clearProperty("java.awt.headless");
            } else {
                System.setProperty("java.awt.headless", headless);
            }
        }
    }

    private void printBanner(Environment environment, PrintStream out) throws IOException {
        RelaxedPropertyResolver properties = new RelaxedPropertyResolver((PropertyResolver)environment, "banner.image.");
        int width = (Integer)properties.getProperty("width", Integer.class, 76);
        int height = (Integer)properties.getProperty("height", Integer.class, 0);
        int margin = (Integer)properties.getProperty("margin", Integer.class, 2);
        boolean invert = (Boolean)properties.getProperty("invert", Boolean.class, false);
        BufferedImage image = this.readImage(width, height);
        this.printBanner(image, margin, invert, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImage(int width, int height) throws IOException {
        InputStream inputStream = this.image.getInputStream();
        try {
            BufferedImage image = ImageIO.read(inputStream);
            BufferedImage bufferedImage = this.resizeImage(image, width, height);
            return bufferedImage;
        }
        finally {
            inputStream.close();
        }
    }

    private BufferedImage resizeImage(BufferedImage image, int width, int height) {
        if (width < 1) {
            width = 1;
        }
        if (height <= 0) {
            double aspectRatio = (double)width / (double)image.getWidth() * 0.5;
            height = (int)Math.ceil((double)image.getHeight() * aspectRatio);
        }
        BufferedImage resized = new BufferedImage(width, height, 1);
        Image scaled = image.getScaledInstance(width, height, 1);
        resized.getGraphics().drawImage(scaled, 0, 0, null);
        return resized;
    }

    private void printBanner(BufferedImage image, int margin, boolean invert, PrintStream out) {
        AnsiBackground background = invert ? AnsiBackground.BLACK : AnsiBackground.DEFAULT;
        out.print(AnsiOutput.encode(AnsiColor.DEFAULT));
        out.print(AnsiOutput.encode(background));
        out.println();
        out.println();
        AnsiColor lastColor = AnsiColor.DEFAULT;
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int i = 0; i < margin; ++i) {
                out.print(" ");
            }
            for (int x = 0; x < image.getWidth(); ++x) {
                Color color = new Color(image.getRGB(x, y), false);
                AnsiColor ansiColor = AnsiColors.getClosest(color);
                if (ansiColor != lastColor) {
                    out.print(AnsiOutput.encode(ansiColor));
                    lastColor = ansiColor;
                }
                out.print(this.getAsciiPixel(color, invert));
            }
            out.println();
        }
        out.print(AnsiOutput.encode(AnsiColor.DEFAULT));
        out.print(AnsiOutput.encode(AnsiBackground.DEFAULT));
        out.println();
    }

    private char getAsciiPixel(Color color, boolean dark) {
        double luminance = this.getLuminance(color, dark);
        for (int i = 0; i < PIXEL.length; ++i) {
            if (!(luminance >= (double)(LUMINANCE_START - i * 10))) continue;
            return PIXEL[i];
        }
        return PIXEL[PIXEL.length - 1];
    }

    private int getLuminance(Color color, boolean inverse) {
        double luminance = 0.0;
        luminance += this.getLuminance(color.getRed(), inverse, RGB_WEIGHT[0]);
        luminance += this.getLuminance(color.getGreen(), inverse, RGB_WEIGHT[1]);
        return (int)Math.ceil((luminance += this.getLuminance(color.getBlue(), inverse, RGB_WEIGHT[2])) / 255.0 * 100.0);
    }

    private double getLuminance(int component, boolean inverse, double weight) {
        return (double)(inverse ? 255 - component : component) * weight;
    }
}

