/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.util.Assert;

public class ServletContextInitializerConfiguration
extends AbstractConfiguration {
    private final ServletContextInitializer[] initializers;

    public ServletContextInitializerConfiguration(ServletContextInitializer ... initializers) {
        Assert.notNull((Object)initializers, (String)"Initializers must not be null");
        this.initializers = initializers;
    }

    public void configure(WebAppContext context) throws Exception {
        context.addBean((Object)new Initializer(context), true);
    }

    private class Initializer
    extends AbstractLifeCycle {
        private final WebAppContext context;

        Initializer(WebAppContext context) {
            this.context = context;
        }

        protected void doStart() throws Exception {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.context.getClassLoader());
            try {
                this.callInitializers();
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void callInitializers() throws ServletException {
            try {
                this.setExtendedListenerTypes(true);
                for (ServletContextInitializer initializer : ServletContextInitializerConfiguration.this.initializers) {
                    initializer.onStartup((ServletContext)this.context.getServletContext());
                }
            }
            finally {
                this.setExtendedListenerTypes(false);
            }
        }

        private void setExtendedListenerTypes(boolean extended) {
            try {
                this.context.getServletContext().setExtendedListenerTypes(extended);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }
}

