/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.Slf4JLoggingSystem;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;

public class Log4J2LoggingSystem
extends Slf4JLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;
    private static final Filter FILTER;

    public Log4J2LoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"log4j2.json", "log4j2.jsn", "log4j2.xml"};
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.getLoggerConfig(null).addFilter(FILTER);
    }

    @Override
    public void initialize(String configLocation, LogFile logFile) {
        this.getLoggerConfig(null).removeFilter(FILTER);
        super.initialize(configLocation, logFile);
    }

    @Override
    protected void loadDefaults(LogFile logFile) {
        if (logFile != null) {
            this.loadConfiguration(this.getPackagedConfigFile("log4j2-file.xml"), logFile);
        } else {
            this.loadConfiguration(this.getPackagedConfigFile("log4j2.xml"), logFile);
        }
    }

    @Override
    protected void loadConfiguration(String location, LogFile logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (logFile != null) {
            logFile.applyToSystemProperties();
        }
        try {
            LoggerContext ctx = this.getLoggerContext();
            URL url = ResourceUtils.getURL((String)location);
            ConfigurationSource source = new ConfigurationSource(url.openStream(), url);
            ctx.start(ConfigurationFactory.getInstance().getConfiguration(source));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Log4J2 logging from " + location, ex);
        }
    }

    @Override
    protected void reinitialize() {
        this.getLoggerContext().reconfigure();
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        this.getLoggerConfig(loggerName).setLevel(LEVELS.get((Object)level));
        this.getLoggerContext().updateLoggers();
    }

    private LoggerConfig getLoggerConfig(String loggerName) {
        LoggerConfig loggerConfig = this.getLoggerContext().getConfiguration().getLoggerConfig(loggerName == null ? "" : loggerName);
        return loggerConfig;
    }

    private LoggerContext getLoggerContext() {
        return (LoggerContext)LogManager.getContext((boolean)false);
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
        FILTER = new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                return Filter.Result.DENY;
            }

            public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
                return Filter.Result.DENY;
            }

            public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
                return Filter.Result.DENY;
            }

            public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
                return Filter.Result.DENY;
            }
        };
    }
}

