/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.test.lexer;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.test.lexer.HasCommentMatcher;
import com.sonar.sslr.test.lexer.HasLastTokenMatcher;
import com.sonar.sslr.test.lexer.HasTokenMatcher;
import com.sonar.sslr.test.lexer.HasTokenTypeMatcher;
import com.sonar.sslr.test.lexer.HasTokenValueMatcher;
import com.sonar.sslr.test.lexer.HasTokensMatcher;
import java.util.List;
import org.hamcrest.Matcher;

public final class LexerMatchers {
    private LexerMatchers() {
    }

    public static Matcher<List<Token>> hasToken(String tokenValue, TokenType tokenType) {
        return new HasTokenMatcher(tokenValue, tokenType);
    }

    public static Matcher<List<Token>> hasToken(String tokenValue) {
        return new HasTokenValueMatcher(tokenValue);
    }

    public static Matcher<List<Token>> hasOriginalToken(String tokenValue) {
        return new HasTokenValueMatcher(tokenValue, true);
    }

    public static Matcher<List<Token>> hasToken(TokenType tokenType) {
        return new HasTokenTypeMatcher(tokenType);
    }

    public static Matcher<List<Token>> hasTokens(String ... tokenValues) {
        return new HasTokensMatcher(tokenValues);
    }

    public static Matcher<List<Token>> hasLastToken(String tokenValue, TokenType tokenType) {
        return new HasLastTokenMatcher(tokenValue, tokenType);
    }

    public static Matcher<List<Token>> hasComment(String commentValue) {
        return new HasCommentMatcher(commentValue);
    }

    public static Matcher<List<Token>> hasComment(String commentValue, int commentLine) {
        return new HasCommentMatcher(commentValue, commentLine);
    }

    public static Matcher<List<Token>> hasOriginalComment(String commentValue) {
        return new HasCommentMatcher(commentValue, true);
    }

    public static Matcher<List<Token>> hasOriginalComment(String commentValue, int commentLine) {
        return new HasCommentMatcher(commentValue, commentLine, true);
    }
}

