/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class IdentifierAndKeywordChannel
extends Channel<Lexer> {
    private final Map<String, TokenType> keywordsMap = new HashMap<String, TokenType>();
    private final StringBuilder tmpBuilder = new StringBuilder();
    private final Matcher matcher;
    private final boolean caseSensitive;
    private final Token.Builder tokenBuilder = Token.builder();

    public IdentifierAndKeywordChannel(String regexp, boolean caseSensitive, TokenType[] ... keywordSets) {
        TokenType[][] tokenTypeArray = keywordSets;
        int n = tokenTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TokenType[] keywords;
            for (TokenType keyword : keywords = tokenTypeArray[i]) {
                String keywordValue = caseSensitive ? keyword.getValue() : keyword.getValue().toUpperCase();
                this.keywordsMap.put(keywordValue, keyword);
            }
        }
        this.caseSensitive = caseSensitive;
        this.matcher = Pattern.compile(regexp).matcher("");
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        if (code.popTo(this.matcher, this.tmpBuilder) > 0) {
            TokenType keywordType;
            String word;
            String wordOriginal = word = this.tmpBuilder.toString();
            if (!this.caseSensitive) {
                word = word.toUpperCase();
            }
            Token token = this.tokenBuilder.setType((keywordType = this.keywordsMap.get(word)) == null ? GenericTokenType.IDENTIFIER : keywordType).setValueAndOriginalValue(word, wordOriginal).setURI(lexer.getURI()).setLine(code.getPreviousCursor().getLine()).setColumn(code.getPreviousCursor().getColumn()).build();
            lexer.addToken(token);
            this.tmpBuilder.delete(0, this.tmpBuilder.length());
            return true;
        }
        return false;
    }
}

