/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.net.Proxy;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class ServerConfiguration {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 60000;
    private final String url;
    private final String organizationKey;
    private final String userAgent;
    private final String login;
    private final String password;
    private final Proxy proxy;
    private final String proxyLogin;
    private final String proxyPassword;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private SSLSocketFactory sslSocketFactory = null;
    private X509TrustManager sslTrustManager = null;

    private ServerConfiguration(Builder builder) {
        this.url = builder.url;
        this.organizationKey = builder.organizationKey;
        this.userAgent = builder.userAgent;
        this.login = builder.login;
        this.password = builder.password;
        this.proxy = builder.proxy;
        this.proxyLogin = builder.proxyLogin;
        this.proxyPassword = builder.proxyPassword;
        this.connectTimeoutMs = builder.connectTimeoutMs;
        this.readTimeoutMs = builder.readTimeoutMs;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.sslTrustManager = builder.sslTrustManager;
    }

    public int hashCode() {
        return Objects.hash(this.connectTimeoutMs, this.login, this.organizationKey, this.password, this.proxy, this.proxyLogin, this.proxyPassword, this.readTimeoutMs, this.url, this.userAgent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ServerConfiguration other = (ServerConfiguration)obj;
        return Objects.equals(this.connectTimeoutMs, other.connectTimeoutMs) && Objects.equals(this.login, other.login) && Objects.equals(this.organizationKey, other.organizationKey) && Objects.equals(this.password, other.password) && Objects.equals(this.url, other.url) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.readTimeoutMs, other.readTimeoutMs) && Objects.equals(this.proxy, other.proxy) && Objects.equals(this.proxyLogin, other.proxyLogin) && Objects.equals(this.proxyPassword, other.proxyPassword);
    }

    public String getUrl() {
        return this.url;
    }

    @CheckForNull
    public String getOrganizationKey() {
        return this.organizationKey;
    }

    @CheckForNull
    public String getUserAgent() {
        return this.userAgent;
    }

    @CheckForNull
    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public X509TrustManager getTrustManager() {
        return this.sslTrustManager;
    }

    @CheckForNull
    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    @CheckForNull
    public String getPassword() {
        return this.password;
    }

    @CheckForNull
    public Proxy getProxy() {
        return this.proxy;
    }

    @CheckForNull
    public String getProxyLogin() {
        return this.proxyLogin;
    }

    @CheckForNull
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String url;
        private String organizationKey;
        private String userAgent;
        private String login;
        private String password;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 60000;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager sslTrustManager = null;

        private Builder() {
        }

        public Builder userAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder organizationKey(@Nullable String organizationKey) {
            this.organizationKey = organizationKey;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder trustManager(X509TrustManager sslTrustManager) {
            this.sslTrustManager = sslTrustManager;
            return this;
        }

        public Builder credentials(@Nullable String login, @Nullable String password) {
            this.login = login;
            this.password = password;
            return this;
        }

        public Builder token(@Nullable String token) {
            this.login = token;
            this.password = null;
            return this;
        }

        public Builder connectTimeoutMilliseconds(int i) {
            this.connectTimeoutMs = i;
            return this;
        }

        public Builder readTimeoutMilliseconds(int i) {
            this.readTimeoutMs = i;
            return this;
        }

        public Builder proxy(@Nullable Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyCredentials(@Nullable String proxyLogin, @Nullable String proxyPassword) {
            this.proxyLogin = proxyLogin;
            this.proxyPassword = proxyPassword;
            return this;
        }

        public ServerConfiguration build() {
            if (this.url == null) {
                throw new UnsupportedOperationException("Server URL is mandatory");
            }
            if (this.userAgent == null) {
                throw new UnsupportedOperationException("User agent is mandatory");
            }
            return new ServerConfiguration(this);
        }
    }
}

