/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.common;

import java.net.Proxy;
import javax.annotation.CheckForNull;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class TelemetryClientConfig {
    private final String userAgent;
    private final Proxy proxy;
    private final String proxyLogin;
    private final String proxyPassword;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;

    public TelemetryClientConfig(Builder builder) {
        this.userAgent = builder.userAgent;
        this.proxyLogin = builder.proxyLogin;
        this.proxyPassword = builder.proxyPassword;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.trustManager = builder.sslTrustManager;
        this.proxy = builder.proxy;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    @CheckForNull
    public String proxyLogin() {
        return this.proxyLogin;
    }

    @CheckForNull
    public String proxyPassword() {
        return this.proxyPassword;
    }

    @CheckForNull
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @CheckForNull
    public X509TrustManager trustManager() {
        return this.trustManager;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String userAgent;
        private Proxy proxy;
        private String proxyLogin;
        private String proxyPassword;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager sslTrustManager = null;

        @CheckForNull
        public String userAgent() {
            return this.userAgent;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @CheckForNull
        public Proxy proxy() {
            return this.proxy;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        @CheckForNull
        public String proxyLogin() {
            return this.proxyLogin;
        }

        public Builder proxyLogin(String proxyLogin) {
            this.proxyLogin = proxyLogin;
            return this;
        }

        @CheckForNull
        public String proxyPassword() {
            return this.proxyPassword;
        }

        public Builder proxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        @CheckForNull
        public SSLSocketFactory sslSocketFactory() {
            return this.sslSocketFactory;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        @CheckForNull
        public X509TrustManager sslTrustManager() {
            return this.sslTrustManager;
        }

        public Builder sslTrustManager(X509TrustManager sslTrustManager) {
            this.sslTrustManager = sslTrustManager;
            return this;
        }

        public TelemetryClientConfig build() {
            return new TelemetryClientConfig(this);
        }
    }
}

