/*
 * Decompiled with CFR 0.152.
 */
package org.skife.config;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.skife.config.Coercer;
import org.skife.config.Coercible;
import org.skife.config.DefaultCoercibles;
import org.skife.config.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Bully {
    private static final List<Coercible<?>> TYPE_COERCIBLES;
    private static final List<Coercible<?>> DEFAULT_COERCIBLES;
    private final Map<Class<?>, Coercer<?>> mappings = new HashMap();
    private final List<Coercible<?>> coercibles = new ArrayList();

    public Bully() {
        this.coercibles.addAll(TYPE_COERCIBLES);
    }

    public void addCoercible(Coercible<?> coercible) {
        this.coercibles.add(coercible);
        this.mappings.clear();
    }

    public synchronized Object coerce(Type type, String value, Separator separator) {
        Type[] args;
        ParameterizedType parameterizedType;
        Type rawType;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return this.coerceArray(clazz.getComponentType(), value, separator);
            }
            return this.coerce(clazz, value);
        }
        if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) instanceof Class && (args = parameterizedType.getActualTypeArguments()) != null && args.length == 1 && args[0] instanceof Class) {
            return this.coerceCollection((Class)rawType, (Class)args[0], value, separator);
        }
        throw new IllegalStateException(String.format("Don't know how to handle a '%s' type for value '%s'", type, value));
    }

    private Object coerceArray(Class<?> elemType, String value, Separator separator) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return Array.newInstance(elemType, 0);
        }
        String[] tokens = value.split(separator == null ? "\\s*,\\s*" : separator.value());
        Object targetArray = Array.newInstance(elemType, tokens.length);
        for (int idx = 0; idx < tokens.length; ++idx) {
            Array.set(targetArray, idx, this.coerce(elemType, tokens[idx]));
        }
        return targetArray;
    }

    private Object coerceCollection(Class<?> containerType, Class<?> elemType, String value, Separator separator) {
        if (value == null) {
            return null;
        }
        Collection<Object> result = null;
        if (Set.class.equals(containerType)) {
            result = new LinkedHashSet();
        } else if (Collection.class.equals(containerType) || List.class.equals(containerType)) {
            result = new ArrayList();
        } else if (Collection.class.isAssignableFrom(containerType)) {
            try {
                Constructor<?> ctor = containerType.getConstructor(new Class[0]);
                if (ctor != null) {
                    result = (Collection)ctor.newInstance(new Object[0]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Don't know how to handle a '%s' container type for value '%s'", containerType, value));
        }
        if (value.length() > 0) {
            for (String token : value.split(separator == null ? "\\s*,\\s*" : separator.value())) {
                result.add(this.coerce(elemType, token));
            }
        }
        return result;
    }

    private Object coerce(Class<?> clazz, String value) {
        Coercer<?> coercer = this.getCoercerFor(this.coercibles, clazz);
        if (coercer == null && (coercer = this.getCoercerFor(DEFAULT_COERCIBLES, clazz)) == null) {
            throw new IllegalStateException(String.format("Don't know how to handle a '%s' type for value '%s'", clazz, value));
        }
        return coercer.coerce(value);
    }

    private Coercer<?> getCoercerFor(List<Coercible<?>> coercibles, Class<?> type) {
        Coercer<?> typeCoercer = this.mappings.get(type);
        if (typeCoercer == null) {
            for (Coercible<?> coercible : coercibles) {
                Coercer<?> coercer = coercible.accept(type);
                if (coercer == null) continue;
                this.mappings.put(type, coercer);
                typeCoercer = coercer;
                break;
            }
        }
        return typeCoercer;
    }

    static {
        ArrayList<Coercible<Object>> typeCoercibles = new ArrayList<Coercible<Object>>();
        ArrayList defaultCoercibles = new ArrayList();
        typeCoercibles.add(DefaultCoercibles.BOOLEAN_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.BYTE_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.SHORT_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.INTEGER_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.LONG_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.FLOAT_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.DOUBLE_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.STRING_COERCIBLE);
        typeCoercibles.add(DefaultCoercibles.URI_COERCIBLE);
        defaultCoercibles.add(DefaultCoercibles.CASE_INSENSITIVE_ENUM_COERCIBLE);
        defaultCoercibles.add(DefaultCoercibles.VALUE_OF_COERCIBLE);
        defaultCoercibles.add(DefaultCoercibles.STRING_CTOR_COERCIBLE);
        defaultCoercibles.add(DefaultCoercibles.OBJECT_CTOR_COERCIBLE);
        TYPE_COERCIBLES = Collections.unmodifiableList(typeCoercibles);
        DEFAULT_COERCIBLES = Collections.unmodifiableList(defaultCoercibles);
    }
}

