/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.sitemesh.webapp.contentfilter.ResponseMetaData;
import org.sitemesh.webapp.contentfilter.Selector;
import org.sitemesh.webapp.contentfilter.io.Buffer;
import org.sitemesh.webapp.contentfilter.io.HttpContentType;
import org.sitemesh.webapp.contentfilter.io.RoutablePrintWriter;
import org.sitemesh.webapp.contentfilter.io.RoutableServletOutputStream;

public class HttpServletResponseBuffer
extends HttpServletResponseWrapper {
    private final RoutablePrintWriter routablePrintWriter;
    private final RoutableServletOutputStream routableServletOutputStream;
    private final Selector selector;
    private final ResponseMetaData metaData;
    private Buffer buffer;
    private boolean bufferingWasDisabled = false;

    public HttpServletResponseBuffer(final HttpServletResponse originalResponse, ResponseMetaData metaData, Selector selector) {
        super(originalResponse);
        this.metaData = metaData;
        this.selector = selector;
        metaData.beginNewResponse();
        this.routablePrintWriter = new RoutablePrintWriter(new RoutablePrintWriter.DestinationFactory(){

            @Override
            public PrintWriter activateDestination() throws IOException {
                HttpServletResponseBuffer.this.preCommit();
                return originalResponse.getWriter();
            }
        });
        this.routableServletOutputStream = new RoutableServletOutputStream(new RoutableServletOutputStream.DestinationFactory(){

            @Override
            public ServletOutputStream create() throws IOException {
                HttpServletResponseBuffer.this.preCommit();
                return originalResponse.getOutputStream();
            }
        });
    }

    public ServletOutputStream getOutputStream() {
        return this.routableServletOutputStream;
    }

    public PrintWriter getWriter() {
        return this.routablePrintWriter;
    }

    public CharBuffer getBuffer() throws IOException {
        if (this.buffer == null) {
            return null;
        }
        return this.buffer.toCharBuffer();
    }

    public boolean isBufferStreamBased() {
        return this.buffer != null && this.buffer.isUsingStream();
    }

    protected void enableBuffering(String encoding) {
        if (this.buffer != null) {
            return;
        }
        this.buffer = new Buffer(encoding);
        this.routablePrintWriter.updateDestination(new RoutablePrintWriter.DestinationFactory(){

            @Override
            public PrintWriter activateDestination() {
                return HttpServletResponseBuffer.this.buffer.getWriter();
            }
        });
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            @Override
            public ServletOutputStream create() {
                return HttpServletResponseBuffer.this.buffer.getOutputStream();
            }
        });
    }

    protected void disableBuffering() {
        this.buffer = null;
        this.bufferingWasDisabled = true;
        this.routablePrintWriter.updateDestination(new RoutablePrintWriter.DestinationFactory(){

            @Override
            public PrintWriter activateDestination() throws IOException {
                HttpServletResponseBuffer.this.preCommit();
                return HttpServletResponseBuffer.this.getResponse().getWriter();
            }
        });
        this.routableServletOutputStream.updateDestination(new RoutableServletOutputStream.DestinationFactory(){

            @Override
            public ServletOutputStream create() throws IOException {
                HttpServletResponseBuffer.this.preCommit();
                return HttpServletResponseBuffer.this.getResponse().getOutputStream();
            }
        });
    }

    public boolean bufferingWasDisabled() {
        return this.bufferingWasDisabled;
    }

    protected void preCommit() {
    }

    public void setContentType(String type) {
        super.setContentType(type);
        HttpContentType httpContentType = new HttpContentType(type);
        if (this.selector.shouldBufferForContentType(type, httpContentType.getType(), httpContentType.getEncoding())) {
            this.enableBuffering(httpContentType.getEncoding());
        } else {
            this.disableBuffering();
        }
    }

    public void setContentLength(int contentLength) {
        if (this.buffer == null) {
            super.setContentLength(contentLength);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.buffer == null) {
            super.flushBuffer();
        }
    }

    public void setHeader(String name, String value) {
        String lowerName = name.toLowerCase();
        if (lowerName.equals("content-type")) {
            this.setContentType(value);
        } else if (this.buffer == null || !lowerName.equals("content-length")) {
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (name.toLowerCase().equals("content-type")) {
            this.setContentType(value);
        } else if (this.buffer == null || !name.toLowerCase().equals("content-length")) {
            super.addHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.buffer == null || !name.toLowerCase().equals("content-length")) {
            super.setIntHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.buffer == null || !name.toLowerCase().equals("content-length")) {
            super.addIntHeader(name, value);
        }
    }

    public void setDateHeader(String name, long value) {
        if (name.toLowerCase().equals("last-modified")) {
            this.metaData.updateLastModified(value);
        } else {
            super.setDateHeader(name, value);
        }
    }

    public void addDateHeader(String name, long value) {
        if (name.toLowerCase().equals("last-modified")) {
            this.metaData.updateLastModified(value);
        } else {
            super.addDateHeader(name, value);
        }
    }

    public void setStatus(int statusCode) {
        this.abortBufferingIfBadStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void setStatus(int statusCode, String reason) {
        this.abortBufferingIfBadStatusCode(statusCode);
        super.setStatus(statusCode);
    }

    public void sendError(int statusCode) throws IOException {
        this.abortBufferingIfBadStatusCode(statusCode);
        super.sendError(statusCode);
    }

    public void sendError(int statusCode, String reason) throws IOException {
        this.abortBufferingIfBadStatusCode(statusCode);
        super.sendError(statusCode, reason);
    }

    public void sendRedirect(String location) throws IOException {
        this.abortBufferingIfBadStatusCode(307);
        super.sendRedirect(location);
    }

    protected void abortBufferingIfBadStatusCode(int statusCode) {
        if (this.selector.shouldAbortBufferingForHttpStatusCode(statusCode)) {
            this.disableBuffering();
        }
    }
}

