/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.CharBuffer;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sitemesh.DecoratorSelector;
import org.sitemesh.config.PathBasedDecoratorSelector;
import org.sitemesh.config.PathMapper;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.webapp.WebAppContext;
import org.sitemesh.webapp.contentfilter.ContentBufferingFilter;
import org.sitemesh.webapp.contentfilter.ResponseMetaData;
import org.sitemesh.webapp.contentfilter.Selector;

public class SiteMeshFilter
extends ContentBufferingFilter {
    private final ContentProcessor contentProcessor;
    private final DecoratorSelector<WebAppContext> decoratorSelector;
    private final boolean includeErrorPages;

    public SiteMeshFilter(Selector selector, ContentProcessor contentProcessor, DecoratorSelector<WebAppContext> decoratorSelector, boolean includeErrorPages) {
        super(selector);
        if (contentProcessor == null) {
            throw new IllegalArgumentException("contentProcessor cannot be null");
        }
        if (decoratorSelector == null) {
            throw new IllegalArgumentException("decoratorSelector cannot be null");
        }
        this.contentProcessor = contentProcessor;
        this.decoratorSelector = decoratorSelector;
        this.includeErrorPages = includeErrorPages;
    }

    @Override
    protected boolean postProcess(String contentType, CharBuffer buffer, HttpServletRequest request, HttpServletResponse response, ResponseMetaData metaData) throws IOException, ServletException {
        String[] decoratorPaths;
        WebAppContext context = this.createContext(contentType, request, response, metaData);
        Content content = this.contentProcessor.build(buffer, context);
        if (content == null) {
            return false;
        }
        for (String decoratorPath : decoratorPaths = this.decoratorSelector.selectDecoratorPaths(content, context)) {
            content = context.decorate(decoratorPath, content);
        }
        if (content == null) {
            return false;
        }
        try {
            content.getData().writeValueTo(response.getWriter());
        }
        catch (IllegalStateException ise) {
            content.getData().writeValueTo(new PrintStream((OutputStream)response.getOutputStream()));
        }
        return true;
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String exclusionPattern = this.getSelector().excludePatternInUse(request);
        if (exclusionPattern != null && this.decoratorSelector instanceof PathBasedDecoratorSelector) {
            PathBasedDecoratorSelector pbds = (PathBasedDecoratorSelector)this.decoratorSelector;
            String decoratorPattern = pbds.getPathMapper().getPatternInUse(WebAppContext.getRequestPath(request));
            if (decoratorPattern == null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (PathMapper.isMoreSpecific(exclusionPattern, decoratorPattern)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        super.doFilter(servletRequest, servletResponse, filterChain);
    }

    protected WebAppContext createContext(String contentType, HttpServletRequest request, HttpServletResponse response, ResponseMetaData metaData) {
        return new WebAppContext(contentType, request, response, this.getFilterConfig().getServletContext(), this.contentProcessor, metaData, this.includeErrorPages);
    }
}

