/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.tagprocessor;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.sitemesh.tagprocessor.Tag;
import org.sitemesh.tagprocessor.TagTokenizer;

public class CustomTag
implements Tag {
    private String[] attributes = new String[10];
    private int attributeCount = 0;
    private String name;
    private Tag.Type type;

    public CustomTag(String name, Tag.Type type) {
        this.setName(name);
        this.setType(type);
    }

    public CustomTag(Tag tag) {
        this.setName(tag.getName());
        this.setType(tag.getType());
        if (tag instanceof TagTokenizer.ReusableToken) {
            TagTokenizer.ReusableToken orig = (TagTokenizer.ReusableToken)tag;
            this.attributeCount = orig.attributeCount;
            this.attributes = new String[this.attributeCount];
            System.arraycopy(orig.attributes, 0, this.attributes, 0, this.attributeCount);
        } else if (tag instanceof CustomTag) {
            CustomTag orig = (CustomTag)tag;
            this.attributeCount = orig.attributeCount;
            this.attributes = new String[this.attributeCount];
            System.arraycopy(orig.attributes, 0, this.attributes, 0, this.attributeCount);
        } else {
            int c = tag.getAttributeCount();
            this.attributes = new String[c * 2];
            for (int i = 0; i < c; ++i) {
                this.attributes[this.attributeCount++] = tag.getAttributeName(i);
                this.attributes[this.attributeCount++] = tag.getAttributeValue(i);
            }
        }
    }

    @Override
    public void writeTo(Appendable out) throws IOException {
        int length = 0;
        length += this.type == Tag.Type.CLOSE ? 2 : 1;
        length += this.name.length();
        for (int i = 0; i < this.attributeCount; i += 2) {
            length += 1 + this.attributes[i].length();
            if (this.attributes[i + 1] == null) continue;
            length += 3 + this.attributes[i + 1].length();
        }
        CharBuffer tag = CharBuffer.allocate(length += this.type == Tag.Type.EMPTY ? 2 : 1);
        tag.put('<');
        if (this.type == Tag.Type.CLOSE) {
            tag.put('/');
        }
        tag.put(this.name);
        for (int i = 0; i < this.attributeCount; i += 2) {
            tag.put(' ').put(this.attributes[i]);
            if (this.attributes[i + 1] == null) continue;
            tag.put('=').put('\"').put(this.attributes[i + 1]).put('\"');
        }
        if (this.type == Tag.Type.EMPTY) {
            tag.put('/');
        }
        tag.put('>');
        assert (tag.remaining() == 0) : "Incorrect buffer length for tag. Please report this to the SiteMesh team.";
        tag.flip();
        out.append(tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomTag)) {
            return false;
        }
        CustomTag customTag = (CustomTag)o;
        return this.type == customTag.type && !(this.attributes == null ? customTag.attributes != null : !Arrays.equals(this.attributes, customTag.attributes)) && !(this.name == null ? customTag.name != null : !this.name.equals(customTag.name));
    }

    public int hashCode() {
        int result = this.attributes != null ? this.attributes.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + this.type.hashCode();
        return result;
    }

    @Override
    public String toString() {
        try {
            StringBuilder out = new StringBuilder(64);
            this.writeTo(out);
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getAttributeCount() {
        return this.attributeCount / 2;
    }

    @Override
    public int getAttributeIndex(String name, boolean caseSensitive) {
        if (this.attributes == null) {
            return -1;
        }
        int len = this.attributeCount;
        for (int i = 0; i < len; i += 2) {
            String current = this.attributes[i];
            if (!(caseSensitive ? name.equals(current) : name.equalsIgnoreCase(current))) continue;
            return i / 2;
        }
        return -1;
    }

    @Override
    public String getAttributeName(int index) {
        return this.attributes[index * 2];
    }

    @Override
    public String getAttributeValue(int index) {
        return this.attributes[index * 2 + 1];
    }

    @Override
    public String getAttributeValue(String name, boolean caseSensitive) {
        int attributeIndex = this.getAttributeIndex(name, caseSensitive);
        if (attributeIndex == -1) {
            return null;
        }
        return this.attributes[attributeIndex * 2 + 1];
    }

    @Override
    public boolean hasAttribute(String name, boolean caseSensitive) {
        return this.getAttributeIndex(name, caseSensitive) > -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Tag.Type getType() {
        return this.type;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("CustomTag requires a name");
        }
        this.name = name;
    }

    public void setType(Tag.Type type) {
        if (type != Tag.Type.OPEN && type != Tag.Type.CLOSE && type != Tag.Type.EMPTY) {
            throw new IllegalArgumentException("CustomTag must be of type Tag.OPEN, Tag.CLOSE or Tag.EMPTY - was " + (Object)((Object)type));
        }
        this.type = type;
    }

    private void growAttributes() {
        int newSize = this.attributes.length == 0 ? 4 : this.attributes.length * 2;
        String[] newAttributes = new String[newSize];
        System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
        this.attributes = newAttributes;
    }

    public int addAttribute(String name, String value) {
        if (this.attributeCount == this.attributes.length) {
            this.growAttributes();
        }
        this.attributes[this.attributeCount++] = name;
        this.attributes[this.attributeCount++] = value;
        return this.attributeCount / 2 - 1;
    }

    public void setAttributeValue(String name, boolean caseSensitive, String value) {
        int attributeIndex = this.getAttributeIndex(name, caseSensitive);
        if (attributeIndex == -1) {
            this.addAttribute(name, value);
        } else {
            this.attributes[attributeIndex * 2 + 1] = value;
        }
    }

    public void setAttributeName(int attributeIndex, String name) {
        this.attributes[attributeIndex * 2] = name;
    }

    public void setAttributeValue(int attributeIndex, String value) {
        this.attributes[attributeIndex * 2 + 1] = value;
    }

    public void removeAttribute(int attributeIndex) {
        if (attributeIndex > this.attributeCount / 2) {
            throw new ArrayIndexOutOfBoundsException("Cannot remove attribute at index " + attributeIndex + ", max index is " + this.attributeCount / 2);
        }
        String[] newAttributes = new String[this.attributes.length - 2];
        System.arraycopy(this.attributes, 0, newAttributes, 0, attributeIndex * 2);
        int next = attributeIndex * 2 + 2;
        System.arraycopy(this.attributes, next, newAttributes, attributeIndex * 2, this.attributes.length - next);
        this.attributeCount -= 2;
        this.attributes = newAttributes;
    }

    public void removeAttribute(String name, boolean caseSensitive) {
        int attributeIndex = this.getAttributeIndex(name, caseSensitive);
        if (attributeIndex == -1) {
            throw new IllegalArgumentException("Attribute " + name + " not found");
        }
        this.removeAttribute(attributeIndex);
    }
}

