/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.offline.directory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.sitemesh.offline.directory.Directory;

public class FileSystemDirectory
implements Directory {
    private final File rootDir;
    private final Charset encoding;

    public FileSystemDirectory(File rootDir) {
        this(rootDir, Charset.defaultCharset());
    }

    public FileSystemDirectory(File rootDir, Charset encoding) {
        this.rootDir = rootDir;
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer load(String path) throws IOException {
        File file = this.getFileByPath(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding));
        try {
            CharBuffer contents = CharBuffer.allocate((int)file.length());
            reader.read(contents);
            contents.flip();
            CharBuffer charBuffer = contents;
            return charBuffer;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String path, CharBuffer contents) throws IOException {
        CharBuffer oldContents;
        File file = this.getFileByPath(path);
        if (file.exists() && (oldContents = this.load(path)).equals(contents)) {
            return;
        }
        file.getParentFile().mkdirs();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding));
        try {
            out.append(contents);
        }
        finally {
            ((Writer)out).close();
        }
    }

    @Override
    public List<String> listAllFilePaths() throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        this.listAllFilePaths("", result);
        return result;
    }

    private void listAllFilePaths(String path, List<String> result) {
        File file = this.getFileByPath(path);
        if (file.isDirectory()) {
            for (String child : file.list()) {
                String childPath = path.length() == 0 ? child : path + "/" + child;
                this.listAllFilePaths(childPath, result);
            }
        }
        if (file.isFile() && file.canRead()) {
            result.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String path, WritableByteChannel channelToWriteTo) throws IOException {
        File file = this.getFileByPath(path);
        FileChannel channel = new FileInputStream(file).getChannel();
        try {
            channel.transferTo(0L, Long.MAX_VALUE, channelToWriteTo);
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String path, ReadableByteChannel channelToReadFrom, int length) throws IOException {
        File tempFile = this.getFileByPath(path + ".tmp");
        File finalFile = this.getFileByPath(path);
        boolean requiresTempFile = finalFile.exists();
        finalFile.getParentFile().mkdirs();
        FileChannel destinationChannel = new FileOutputStream(requiresTempFile ? tempFile : finalFile).getChannel();
        try {
            destinationChannel.transferFrom(channelToReadFrom, 0L, length);
        }
        finally {
            destinationChannel.close();
        }
        if (requiresTempFile) {
            if (this.computeChecksum(tempFile) == this.computeChecksum(finalFile)) {
                tempFile.delete();
            } else {
                finalFile.delete();
                tempFile.renameTo(finalFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeChecksum(File file) throws IOException {
        CheckedInputStream checkedInput = new CheckedInputStream(new FileInputStream(file), new CRC32());
        try {
            while (checkedInput.read() > -1) {
            }
        }
        finally {
            checkedInput.close();
        }
        return checkedInput.getChecksum().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(String path, Directory destinationDirectory, String destinationPath) throws IOException {
        FileChannel sourceChannel = new FileInputStream(this.getFileByPath(path)).getChannel();
        try {
            destinationDirectory.save(destinationPath, sourceChannel, (int)sourceChannel.size());
        }
        finally {
            sourceChannel.close();
        }
    }

    public File getFileByPath(String path) {
        return new File(this.rootDir, path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemDirectory that = (FileSystemDirectory)o;
        if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
            return false;
        }
        return !(this.rootDir != null ? !this.rootDir.equals(that.rootDir) : that.rootDir != null);
    }

    public int hashCode() {
        int result = this.rootDir != null ? this.rootDir.hashCode() : 0;
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "FileSystemDirectory{rootDir=" + this.rootDir + ", encoding=" + this.encoding + '}';
    }
}

