/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.tagrules.html;

import java.io.IOException;
import java.nio.CharBuffer;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.content.ContentProperty;
import org.sitemesh.tagprocessor.BasicBlockRule;
import org.sitemesh.tagprocessor.CustomTag;
import org.sitemesh.tagprocessor.Tag;

public class ExportTagToContentRule
extends BasicBlockRule {
    private final ContentProperty targetProperty;
    private final boolean includeInContent;
    private final SiteMeshContext context;

    public ExportTagToContentRule(SiteMeshContext context, ContentProperty targetProperty, boolean includeInContent) {
        this.targetProperty = targetProperty;
        this.includeInContent = includeInContent;
        this.context = context;
    }

    protected Object processStart(Tag tag) throws IOException {
        Tag t = tag;
        for (int i = 0; i < t.getAttributeCount(); ++i) {
            String value = t.getAttributeValue(i);
            if (value != null && value.indexOf(60) < value.indexOf(62)) {
                StringBuilder sb = new StringBuilder();
                this.context.getContentProcessor().build(CharBuffer.wrap(value), this.context).getData().writeValueTo(sb);
                value = sb.toString();
                if (!(t instanceof CustomTag)) {
                    t = new CustomTag(t);
                }
                CustomTag custom = (CustomTag)t;
                custom.setAttributeValue(i, value);
            }
            ((ContentProperty)this.targetProperty.getChild(t.getAttributeName(i))).setValue(value);
        }
        if (!this.includeInContent) {
            this.tagProcessorContext.pushBuffer(this.targetProperty.getOwningContent().createDataOnlyBuffer());
        } else {
            this.tagProcessorContext.pushBuffer();
        }
        t.writeTo(this.tagProcessorContext.currentBuffer());
        this.tagProcessorContext.pushBuffer();
        return null;
    }

    protected void processEnd(Tag tag, Object data) throws IOException {
        CharSequence innerContent = this.tagProcessorContext.currentBufferContents();
        this.tagProcessorContext.popBuffer();
        this.tagProcessorContext.currentBuffer().append(innerContent);
        if (tag.getType() != Tag.Type.EMPTY) {
            tag.writeTo(this.tagProcessorContext.currentBuffer());
        }
        CharSequence outerContent = this.tagProcessorContext.currentBufferContents();
        this.tagProcessorContext.popBuffer();
        this.tagProcessorContext.currentBuffer().append(outerContent);
        if (!this.targetProperty.hasValue()) {
            this.targetProperty.setValue(innerContent);
        }
    }
}

