/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.tagrules.html;

import java.io.IOException;
import org.sitemesh.content.ContentProperty;
import org.sitemesh.tagprocessor.BasicBlockRule;
import org.sitemesh.tagprocessor.Tag;

public class DivExtractingRule
extends BasicBlockRule<String> {
    private final ContentProperty propertyToExport;

    public DivExtractingRule(ContentProperty propertyToExport) {
        this.propertyToExport = propertyToExport;
    }

    @Override
    protected String processStart(Tag tag) throws IOException {
        this.ensureTagIsNotConsumed(tag);
        if (this.shouldCapture(tag)) {
            this.pushContent();
        }
        return this.getId(tag);
    }

    @Override
    protected void processEnd(Tag tag, String id) throws IOException {
        if (this.capturing(id)) {
            CharSequence tagContent = this.popContent();
            ((ContentProperty)this.propertyToExport.getChild(id)).setValue(tagContent);
            this.ensureContentIsNotConsumed(tagContent);
        }
        this.ensureTagIsNotConsumed(tag);
    }

    private void ensureContentIsNotConsumed(CharSequence content) throws IOException {
        this.tagProcessorContext.currentBuffer().append(content);
    }

    private CharSequence popContent() {
        CharSequence content = this.tagProcessorContext.currentBufferContents();
        this.tagProcessorContext.popBuffer();
        return content;
    }

    private boolean capturing(String id) {
        return id != null;
    }

    private void pushContent() {
        this.tagProcessorContext.pushBuffer();
    }

    private String getId(Tag tag) {
        return tag.getAttributeValue("id", false);
    }

    private boolean shouldCapture(Tag tag) {
        return tag.hasAttribute("id", false);
    }

    private void ensureTagIsNotConsumed(Tag tag) throws IOException {
        tag.writeTo(this.tagProcessorContext.currentBuffer());
    }
}

