/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.debug;

import java.io.IOException;
import java.nio.CharBuffer;
import org.sitemesh.SiteMeshContext;
import org.sitemesh.content.Content;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.content.ContentProperty;

public class DumpingContentProcessor
implements ContentProcessor {
    private final ContentProcessor contentProcessor;
    private final Appendable debugOut;

    public DumpingContentProcessor(ContentProcessor contentProcessor, Appendable debugOut) {
        this.contentProcessor = contentProcessor;
        this.debugOut = debugOut;
    }

    @Override
    public Content build(CharBuffer data, SiteMeshContext context) throws IOException {
        Content result = this.contentProcessor.build(data, context);
        DumpingContentProcessor.dump(result, this.debugOut);
        return result;
    }

    public static void dump(Content content, Appendable out) throws IOException {
        out.append("~~~~~~ MAIN ~~~~~~");
        content.getData().writeValueTo(out);
        for (ContentProperty descendant : content.getExtractedProperties().getDescendants()) {
            out.append("~~~~~~ " + DumpingContentProcessor.getFullPath(descendant) + " ~~~~~~");
            descendant.writeValueTo(out);
            out.append("\n\n");
        }
    }

    public static String dump(Content content) {
        StringBuilder result = new StringBuilder();
        try {
            DumpingContentProcessor.dump(content, result);
        }
        catch (IOException e) {
            return "Exception: " + e.toString();
        }
        return result.toString();
    }

    public static String getFullPath(ContentProperty contentProperty) {
        StringBuilder result = new StringBuilder();
        for (ContentProperty item : (ContentProperty[])contentProperty.getFullPath()) {
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(item.getName());
        }
        return result.toString();
    }
}

