/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config.xml;

import java.util.ArrayList;
import java.util.List;
import org.sitemesh.builder.BaseSiteMeshBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.xml.Xml;
import org.sitemesh.content.ContentProcessor;
import org.sitemesh.content.tagrules.TagRuleBundle;
import org.w3c.dom.Element;

public class XmlConfigurator {
    private final Xml xml;
    private final ObjectFactory objectFactory;

    public XmlConfigurator(ObjectFactory objectFactory, Element siteMeshElement) {
        this.objectFactory = objectFactory;
        this.xml = new Xml(siteMeshElement);
    }

    public void configureCommon(BaseSiteMeshBuilder builder) {
        for (Xml tagRuleBundle : this.xml.child("content-processor").children("tag-rule-bundle")) {
            String tagRuleBundleName = tagRuleBundle.attribute("class");
            if (tagRuleBundleName == null) continue;
            builder.addTagRuleBundle((TagRuleBundle)this.objectFactory.create(tagRuleBundleName));
        }
        String contentProcessorName = this.xml.child("content-processor").attribute("class");
        if (contentProcessorName != null) {
            builder.setCustomContentProcessor((ContentProcessor)this.objectFactory.create(contentProcessorName));
        }
        for (Xml mapping : this.xml.children("mapping")) {
            List<Xml> paths = this.xml.children("path");
            if (!paths.isEmpty()) {
                for (Xml path : this.xml.children("mapping")) {
                    this.addDecoratorPaths(builder, mapping, path.text());
                }
                continue;
            }
            this.addDecoratorPaths(builder, mapping, mapping.attribute("path", "/*"));
        }
    }

    private void addDecoratorPaths(BaseSiteMeshBuilder builder, Xml mapping, String path) {
        ArrayList<String> decorators = new ArrayList<String>();
        if (mapping.attribute("decorator") != null) {
            decorators.add(mapping.attribute("decorator"));
        }
        for (Xml decorator : mapping.children("decorator")) {
            if (decorator.text() == null) continue;
            decorators.add(decorator.text());
        }
        builder.addDecoratorPaths(path, decorators);
    }

    protected ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }
}

