/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PathMapper<T> {
    public static final Set<String> DEFAULT_KEYS;
    private final Map<String, T> mappings = new HashMap<String, T>();

    public void put(String pattern, T value) {
        if (value != null) {
            this.mappings.put(pattern, value);
        }
    }

    public T get(String path) {
        String mapped;
        String result;
        if (path == null) {
            path = "/";
        }
        if ((result = this.findExactKey(path)) == null) {
            result = this.findComplexKey(path);
        }
        if (result == null) {
            result = this.findDefaultKey();
        }
        if ((mapped = result) == null) {
            return null;
        }
        return this.mappings.get(mapped);
    }

    public String getPatternInUse(String path) {
        String result;
        if (path == null) {
            path = "/";
        }
        if ((result = this.findExactKey(path)) == null) {
            result = this.findComplexKey(path);
        }
        if (result == null) {
            result = this.findDefaultKey();
        }
        return result;
    }

    private String findExactKey(String path) {
        if (this.mappings.containsKey(path)) {
            return path;
        }
        return null;
    }

    private String findComplexKey(String path) {
        String result = null;
        for (String key : this.mappings.keySet()) {
            if (!PathMapper.isComplexKey(key) || !PathMapper.match(key, path, false) || result != null && key.length() <= result.length()) continue;
            result = key;
        }
        return result;
    }

    public static boolean isComplexKey(String key) {
        return key.length() > 1 && (key.indexOf(63) != -1 || key.indexOf(42) != -1);
    }

    public static boolean isDefaultKey(String key) {
        return DEFAULT_KEYS.contains(key);
    }

    private String findDefaultKey() {
        for (String defaultKey : DEFAULT_KEYS) {
            if (!this.mappings.containsKey(defaultKey)) continue;
            return defaultKey;
        }
        return null;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        int i;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (i = 0; i < patArr.length; ++i) {
            if (patArr[i] != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?') continue;
                if (isCaseSensitive && ch2 != strArr[i]) {
                    return false;
                }
                if (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i])) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i2 = patIdxStart + 1; i2 <= patIdxEnd; ++i2) {
                if (patArr[i2] != '*') continue;
                patIdxTmp = i2;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i3 = 0; i3 <= strLength - patLength; ++i3) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart + i3 + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i3 + j]))) continue block8;
                }
                foundIdx = strIdxStart + i3;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }

    public static boolean isMoreSpecific(String exclusionPattern, String decoratorPattern) {
        if (PathMapper.isDefaultKey(decoratorPattern)) {
            return true;
        }
        if (PathMapper.isComplexKey(decoratorPattern)) {
            if (PathMapper.isComplexKey(exclusionPattern)) {
                return exclusionPattern.length() >= decoratorPattern.length();
            }
            return !PathMapper.isDefaultKey(decoratorPattern);
        }
        return !PathMapper.isComplexKey(exclusionPattern) && !PathMapper.isDefaultKey(exclusionPattern);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("/");
        set.add("*");
        set.add("**");
        set.add("/*");
        set.add("/**");
        DEFAULT_KEYS = Collections.unmodifiableSet(set);
    }
}

