/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.webapp.contentfilter.io;

import java.nio.ByteBuffer;
import java.util.LinkedList;

public class ByteBufferBuilder {
    private static final int DEFAULT_BLOCK_SIZE = 8192;
    private byte[] buffer;
    private LinkedList<byte[]> buffers;
    private int index;
    private int size;
    private int blockSize;

    public ByteBufferBuilder() {
        this(8192);
    }

    public ByteBufferBuilder(int aSize) {
        this.blockSize = aSize;
        this.buffer = new byte[this.blockSize];
    }

    public int size() {
        return this.size + this.index;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer result = ByteBuffer.allocate(this.size());
        if (this.buffers != null) {
            for (byte[] current : this.buffers) {
                result.put(current);
            }
        }
        result.put(this.buffer, 0, this.index);
        result.flip();
        return result;
    }

    public void write(int datum) {
        if (this.index == this.blockSize) {
            if (this.buffers == null) {
                this.buffers = new LinkedList();
            }
            this.buffers.addLast(this.buffer);
            this.buffer = new byte[this.blockSize];
            this.size += this.index;
            this.index = 0;
        }
        this.buffer[this.index++] = (byte)datum;
    }

    public void write(byte[] data, int offset, int length) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.index + length >= this.blockSize) {
            for (int i = 0; i < length; ++i) {
                this.write(data[offset + i]);
            }
        } else {
            System.arraycopy(data, offset, this.buffer, this.index, length);
            this.index += length;
        }
    }

    public String toString() {
        return this.toByteBuffer().toString();
    }
}

