/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.tagprocessor;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.sitemesh.tagprocessor.Lexer;
import org.sitemesh.tagprocessor.Tag;

public class TagTokenizer {
    private final Lexer lexer;
    private final ReusableToken reusableToken = new ReusableToken();
    private Token pushbackToken = Token.UNKNOWN;
    private String pushbackText;
    private final CharSequence input;
    private int position;
    private int length;
    private boolean bufferingText;
    private int bufferedTextStart;
    private int bufferedTextEnd;
    private String name;
    private Tag.Type type;
    private final TokenHandler handler;

    public TagTokenizer(CharBuffer input, TokenHandler handler) {
        this.handler = handler;
        this.lexer = new Lexer(new CharBufferReader(input));
        this.lexer.setHandler(handler);
        this.input = input;
    }

    public void start() {
        try {
            while (true) {
                Token token;
                if (this.pushbackToken == Token.UNKNOWN) {
                    token = this.lexer.nextToken();
                } else {
                    token = this.pushbackToken;
                    this.pushbackToken = Token.UNKNOWN;
                }
                if (token == Token.EOF) {
                    this.flushText();
                    return;
                }
                if (token == Token.TEXT) {
                    int start = this.lexer.position();
                    this.parsedText(start, start + this.lexer.length());
                    continue;
                }
                if (token == Token.LT) {
                    this.parseTag(Tag.Type.OPEN);
                    continue;
                }
                if (token == Token.LT_OPEN_MAGIC_COMMENT) {
                    this.parseTag(Tag.Type.OPEN_CONDITIONAL_COMMENT);
                    continue;
                }
                if (token == Token.LT_CLOSE_MAGIC_COMMENT) {
                    this.parseTag(Tag.Type.CLOSE_CONDITIONAL_COMMENT);
                    continue;
                }
                this.reportError("Unexpected token from lexer, was expecting TEXT or LT", this.lexer.line(), this.lexer.column());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String text() {
        if (this.pushbackToken == Token.UNKNOWN) {
            return this.lexer.yytext();
        }
        return this.pushbackText;
    }

    private void skipWhiteSpace() throws IOException {
        Token next;
        do {
            if (this.pushbackToken == Token.UNKNOWN) {
                next = this.lexer.nextToken();
                continue;
            }
            next = this.pushbackToken;
            this.pushbackToken = Token.UNKNOWN;
        } while (next == Token.WHITESPACE);
        this.pushBack(next);
    }

    private void pushBack(Token next) {
        if (this.pushbackToken != Token.UNKNOWN) {
            this.reportError("Cannot pushback more than once", this.lexer.line(), this.lexer.column());
        }
        this.pushbackToken = next;
        this.pushbackText = next == Token.WORD || next == Token.QUOTED || next == Token.SLASH || next == Token.EQUALS ? this.lexer.yytext() : null;
    }

    private void parseTag(Tag.Type type) throws IOException {
        Token token;
        int start = this.lexer.position();
        this.skipWhiteSpace();
        if (this.pushbackToken == Token.UNKNOWN) {
            token = this.lexer.nextToken();
        } else {
            token = this.pushbackToken;
            this.pushbackToken = Token.UNKNOWN;
        }
        if (token == Token.SLASH) {
            type = Tag.Type.CLOSE;
            if (this.pushbackToken == Token.UNKNOWN) {
                token = this.lexer.nextToken();
            } else {
                token = this.pushbackToken;
                this.pushbackToken = Token.UNKNOWN;
            }
        }
        if (token == Token.WORD) {
            String name = this.text();
            if (this.handler.shouldProcessTag(name)) {
                this.parseFullTag(type, name, start);
            } else {
                this.lexer.resetLexerState();
                this.pushBack(this.lexer.nextToken());
                this.parsedText(start, this.lexer.position());
            }
        } else if (token == Token.GT) {
            this.parsedText(start, this.lexer.position() + 1);
        } else if (token == Token.EOF) {
            this.parsedText(start, this.lexer.position());
        } else {
            this.reportError("Could not recognise tag", this.lexer.line(), this.lexer.column());
        }
    }

    private void parseFullTag(Tag.Type type, String name, int start) throws IOException {
        Token token;
        block13: {
            while (true) {
                this.skipWhiteSpace();
                if (this.pushbackToken == Token.UNKNOWN) {
                    token = this.lexer.nextToken();
                } else {
                    token = this.pushbackToken;
                    this.pushbackToken = Token.UNKNOWN;
                }
                this.pushBack(token);
                if (token == Token.SLASH || token == Token.GT) break block13;
                if (token != Token.WORD) break;
                this.parseAttribute();
            }
            if (token == Token.EOF) {
                this.parsedText(start, this.lexer.position());
                return;
            }
            this.reportError("Illegal tag", this.lexer.line(), this.lexer.column());
        }
        if (this.pushbackToken == Token.UNKNOWN) {
            token = this.lexer.nextToken();
        } else {
            token = this.pushbackToken;
            this.pushbackToken = Token.UNKNOWN;
        }
        if (token == Token.SLASH) {
            type = Tag.Type.EMPTY;
            if (this.pushbackToken == Token.UNKNOWN) {
                token = this.lexer.nextToken();
            } else {
                token = this.pushbackToken;
                this.pushbackToken = Token.UNKNOWN;
            }
        }
        if (token == Token.GT) {
            this.parsedTag(type, name, start, this.lexer.position() - start + 1);
        } else if (token == Token.EOF) {
            this.parsedText(start, this.lexer.position());
        } else {
            this.reportError("Expected end of tag", this.lexer.line(), this.lexer.column());
            this.parsedTag(type, name, start, this.lexer.position() - start + 1);
        }
    }

    private void parseAttribute() throws IOException {
        Token token;
        if (this.pushbackToken == Token.UNKNOWN) {
            this.lexer.nextToken();
        } else {
            this.pushbackToken = Token.UNKNOWN;
        }
        String attributeName = this.text();
        this.skipWhiteSpace();
        if (this.pushbackToken == Token.UNKNOWN) {
            token = this.lexer.nextToken();
        } else {
            token = this.pushbackToken;
            this.pushbackToken = Token.UNKNOWN;
        }
        if (token == Token.EQUALS) {
            this.skipWhiteSpace();
            if (this.pushbackToken == Token.UNKNOWN) {
                token = this.lexer.nextToken();
            } else {
                token = this.pushbackToken;
                this.pushbackToken = Token.UNKNOWN;
            }
            if (token == Token.QUOTED) {
                this.parsedAttribute(attributeName, this.text(), true);
            } else if (token == Token.WORD || token == Token.SLASH) {
                Token next;
                String attributeValue = this.text();
                while (true) {
                    if (this.pushbackToken == Token.UNKNOWN) {
                        next = this.lexer.nextToken();
                    } else {
                        next = this.pushbackToken;
                        this.pushbackToken = Token.UNKNOWN;
                    }
                    if (next != Token.WORD && next != Token.EQUALS && next != Token.SLASH) break;
                    attributeValue = attributeValue + this.text();
                }
                this.pushBack(next);
                this.parsedAttribute(attributeName, attributeValue, false);
            } else if (token == Token.SLASH || token == Token.GT) {
                this.pushBack(token);
            } else if (token != Token.EOF) {
                this.reportError("Illegal attribute value", this.lexer.line(), this.lexer.column());
            }
        } else if (token == Token.SLASH || token == Token.GT || token == Token.WORD) {
            this.parsedAttribute(attributeName, null, false);
            this.pushBack(token);
        } else if (token != Token.EOF) {
            this.reportError("Illegal attribute name", this.lexer.line(), this.lexer.column());
        }
    }

    private void flushText() throws IOException {
        if (this.bufferingText) {
            this.handler.text(this.input.subSequence(this.bufferedTextStart, this.bufferedTextEnd));
            this.bufferingText = false;
        }
    }

    private void parsedText(int start, int end) throws IOException {
        if (!this.bufferingText) {
            this.bufferingText = true;
            this.bufferedTextStart = start;
            this.bufferedTextEnd = end;
        } else {
            assert (this.bufferedTextEnd == start) : "Parser missed something. Please report this bug to SiteMesh team.";
            this.bufferedTextEnd = end;
        }
    }

    private void parsedTag(Tag.Type type, String name, int start, int length) throws IOException {
        this.flushText();
        this.type = type;
        this.name = name;
        this.position = start;
        this.length = length;
        this.handler.tag(this.reusableToken);
        this.reusableToken.attributeCount = 0;
    }

    private void parsedAttribute(String name, String value, boolean quoted) {
        if (this.reusableToken.attributeCount + 2 >= this.reusableToken.attributes.length) {
            String[] newAttributes = new String[this.reusableToken.attributeCount * 2];
            System.arraycopy(this.reusableToken.attributes, 0, newAttributes, 0, this.reusableToken.attributeCount);
            this.reusableToken.attributes = newAttributes;
        }
        this.reusableToken.attributes[this.reusableToken.attributeCount++] = name;
        this.reusableToken.attributes[this.reusableToken.attributeCount++] = quoted ? value.substring(1, value.length() - 1) : value;
    }

    private void reportError(String message, int line, int column) {
        this.handler.warning(message, line, column);
    }

    private static class CharBufferReader
    extends Reader {
        private final CharBuffer input;

        public CharBufferReader(CharBuffer input) {
            this.input = input.duplicate();
        }

        public int read(char[] chars, int offset, int length) throws IOException {
            int read = Math.min(this.input.remaining(), length);
            this.input.get(chars, offset, read);
            return read;
        }

        public int read() throws IOException {
            return this.input.position() < this.input.limit() ? (int)this.input.get() : -1;
        }

        public void close() throws IOException {
        }
    }

    public class ReusableToken
    implements Tag {
        public int attributeCount = 0;
        public String[] attributes = new String[10];

        public String getName() {
            return TagTokenizer.this.name;
        }

        public Tag.Type getType() {
            return TagTokenizer.this.type;
        }

        public void writeTo(Appendable out) throws IOException {
            out.append(TagTokenizer.this.input.subSequence(TagTokenizer.this.position, TagTokenizer.this.position + TagTokenizer.this.length));
        }

        public int getAttributeCount() {
            return this.attributeCount / 2;
        }

        public int getAttributeIndex(String name, boolean caseSensitive) {
            if (this.attributeCount == 0) {
                return -1;
            }
            int len = this.attributeCount;
            for (int i = 0; i < len; i += 2) {
                String current = this.attributes[i];
                if (!(caseSensitive ? name.equals(current) : name.equalsIgnoreCase(current))) continue;
                return i / 2;
            }
            return -1;
        }

        public String getAttributeName(int index) {
            return this.attributes[index * 2];
        }

        public String getAttributeValue(int index) {
            return this.attributes[index * 2 + 1];
        }

        public String getAttributeValue(String name, boolean caseSensitive) {
            if (this.attributeCount == 0) {
                return null;
            }
            int len = this.attributeCount;
            for (int i = 0; i < len; i += 2) {
                String current = this.attributes[i];
                if (!(caseSensitive ? name.equals(current) : name.equalsIgnoreCase(current))) continue;
                return this.attributes[i + 1];
            }
            return null;
        }

        public boolean hasAttribute(String name, boolean caseSensitive) {
            return this.getAttributeIndex(name, caseSensitive) > -1;
        }

        public String toString() {
            return ((Object)TagTokenizer.this.input.subSequence(TagTokenizer.this.position, TagTokenizer.this.position + TagTokenizer.this.length)).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        UNKNOWN,
        SLASH,
        WHITESPACE,
        EQUALS,
        QUOTE,
        WORD,
        TEXT,
        QUOTED,
        LT,
        GT,
        LT_OPEN_MAGIC_COMMENT,
        LT_CLOSE_MAGIC_COMMENT,
        EOF;

    }

    public static interface TokenHandler {
        public boolean shouldProcessTag(String var1);

        public void tag(Tag var1) throws IOException;

        public void text(CharSequence var1) throws IOException;

        public void warning(String var1, int var2, int var3);
    }
}

