/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.content.tagrules.html;

import java.io.IOException;
import org.sitemesh.content.ContentProperty;
import org.sitemesh.tagprocessor.BasicBlockRule;
import org.sitemesh.tagprocessor.Tag;

public class ExportTagToContentRule
extends BasicBlockRule {
    private final ContentProperty targetProperty;
    private final boolean includeInContent;

    public ExportTagToContentRule(ContentProperty targetProperty, boolean includeInContent) {
        this.targetProperty = targetProperty;
        this.includeInContent = includeInContent;
    }

    protected Object processStart(Tag tag) throws IOException {
        for (int i = 0; i < tag.getAttributeCount(); ++i) {
            ((ContentProperty)this.targetProperty.getChild(tag.getAttributeName(i))).setValue(tag.getAttributeValue(i));
        }
        if (!this.includeInContent) {
            this.tagProcessorContext.pushBuffer(this.targetProperty.getOwningContent().createDataOnlyBuffer());
        } else {
            this.tagProcessorContext.pushBuffer();
        }
        tag.writeTo(this.tagProcessorContext.currentBuffer());
        this.tagProcessorContext.pushBuffer();
        return null;
    }

    protected void processEnd(Tag tag, Object data) throws IOException {
        CharSequence innerContent = this.tagProcessorContext.currentBufferContents();
        this.tagProcessorContext.popBuffer();
        this.tagProcessorContext.currentBuffer().append(innerContent);
        if (tag.getType() != Tag.Type.EMPTY) {
            tag.writeTo(this.tagProcessorContext.currentBuffer());
        }
        CharSequence outerContent = this.tagProcessorContext.currentBufferContents();
        this.tagProcessorContext.popBuffer();
        this.tagProcessorContext.currentBuffer().append(outerContent);
        if (!this.targetProperty.hasValue()) {
            this.targetProperty.setValue(innerContent);
        }
    }
}

