/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sitemesh.builder.SiteMeshFilterBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.properties.PropertiesFilterConfigurator;
import org.sitemesh.config.xml.XmlFilterConfigurator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableSiteMeshFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ConfigurableSiteMeshFilter.class.getName());
    private boolean initialized;
    private File xmlConfigFile;
    private FilterConfig filterConfig;
    private Map<String, String> configProperties;
    private boolean autoReload;
    private volatile Filter filter;
    private volatile long timestampOfXmlFileAtLastLoad;
    private final Object configLock = new Object();
    public static final String CONFIG_FILE_PARAM = "configFile";
    public static final String CONFIG_FILE_DEFAULT = "/WEB-INF/sitemesh3.xml";
    public static final String AUTO_RELOAD_PARAM = "autoReload";
    public static final boolean AUTO_RELOAD_DEFAULT = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.configProperties = this.getConfigProperties(filterConfig);
        this.autoReload = this.getAutoReload();
        logger.config("Auto reloading " + (this.autoReload ? "enabled" : "disabled"));
        Object object = this.configLock;
        synchronized (object) {
            this.deployNewFilter(this.setup());
        }
        this.initialized = true;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.initialized) {
            throw new ServletException(this.getClass().getName() + ".init(FilterConfig) was not called");
        }
        this.reloadIfNecessary();
        this.filter.doFilter(servletRequest, servletResponse, filterChain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.configLock;
        synchronized (object) {
            if (this.filter != null) {
                this.filter.destroy();
            }
        }
    }

    protected Map<String, String> getConfigProperties(FilterConfig filterConfig) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        Enumeration initParameterNames = filterConfig.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String key = (String)initParameterNames.nextElement();
            String value = filterConfig.getInitParameter(key).trim();
            initParams.put(key, value);
        }
        return initParams;
    }

    protected Filter setup() throws ServletException {
        ObjectFactory objectFactory = this.getObjectFactory();
        SiteMeshFilterBuilder builder = new SiteMeshFilterBuilder();
        new PropertiesFilterConfigurator(objectFactory, this.configProperties).configureFilter(builder);
        new XmlFilterConfigurator(this.getObjectFactory(), this.loadConfigXml(this.filterConfig, this.getConfigFileName())).configureFilter(builder);
        this.applyCustomConfiguration(builder);
        return builder.create();
    }

    protected void applyCustomConfiguration(SiteMeshFilterBuilder builder) {
    }

    protected boolean reloadRequired() {
        return this.timestampOfXmlFileAtLastLoad != this.xmlConfigFile.lastModified();
    }

    protected boolean getAutoReload() {
        String autoReload = this.configProperties.get(AUTO_RELOAD_PARAM);
        if (autoReload == null) {
            return true;
        }
        String lower = autoReload.toLowerCase();
        return lower.equals("1") || lower.equals("true") || lower.equals("yes");
    }

    protected String getConfigFileName() {
        String config = this.configProperties.get(CONFIG_FILE_PARAM);
        if (config == null || config.isEmpty()) {
            config = CONFIG_FILE_DEFAULT;
        }
        return config;
    }

    protected ObjectFactory getObjectFactory() {
        return new ObjectFactory.Default();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Element loadConfigXml(FilterConfig filterConfig, String configFilePath) throws ServletException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            this.xmlConfigFile = new File(configFilePath);
            ServletContext servletContext = filterConfig.getServletContext();
            if (servletContext.getRealPath(configFilePath) != null) {
                this.xmlConfigFile = new File(servletContext.getRealPath(configFilePath));
            }
            if (this.xmlConfigFile.canRead()) {
                try {
                    this.timestampOfXmlFileAtLastLoad = this.xmlConfigFile.lastModified();
                    logger.config("Loading SiteMesh 3 config file: " + this.xmlConfigFile.getAbsolutePath());
                    Document document = documentBuilder.parse(this.xmlConfigFile);
                    return document.getDocumentElement();
                }
                catch (SAXException e) {
                    throw new ServletException("Could not parse " + this.xmlConfigFile.getAbsolutePath(), (Throwable)e);
                }
            }
            InputStream stream = servletContext.getResourceAsStream(configFilePath);
            if (stream == null) {
                logger.config("No config file present - using defaults and init-params. Tried: " + this.xmlConfigFile.getAbsolutePath() + " and ServletContext:" + configFilePath);
                return null;
            }
            try {
                logger.config("Loading SiteMesh 3 config file from ServletContext " + configFilePath);
                Document document = documentBuilder.parse(stream);
                Element element = document.getDocumentElement();
                return element;
            }
            catch (SAXException e) {
                throw new ServletException("Could not parse " + configFilePath + " (loaded by ServletContext)", (Throwable)e);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("Could not initialize DOM parser", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadIfNecessary() throws ServletException {
        if (this.autoReload && this.reloadRequired()) {
            Object object = this.configLock;
            synchronized (object) {
                if (this.reloadRequired()) {
                    this.deployNewFilter(this.setup());
                }
            }
        }
    }

    protected void deployNewFilter(Filter newFilter) throws ServletException {
        Filter oldFilter = this.filter;
        if (newFilter == null) {
            throw new ServletException("Cannot deploy null filter");
        }
        newFilter.init(this.filterConfig);
        this.filter = newFilter;
        if (oldFilter != null) {
            oldFilter.destroy();
        }
    }
}

