/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.builder;

import java.io.File;
import org.sitemesh.builder.BaseSiteMeshBuilder;
import org.sitemesh.offline.OfflineContext;
import org.sitemesh.offline.SiteMeshOffline;
import org.sitemesh.offline.directory.Directory;
import org.sitemesh.offline.directory.FileSystemDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSiteMeshOfflineBuilder<BUILDER extends BaseSiteMeshOfflineBuilder>
extends BaseSiteMeshBuilder<BUILDER, OfflineContext, SiteMeshOffline> {
    private Directory sourceDirectory;
    private Directory destinationDirectory;

    @Override
    public abstract SiteMeshOffline create();

    public BUILDER setSourceDirectory(Directory sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public BUILDER setSourceDirectory(File sourceDirectory) {
        this.setSourceDirectory(new FileSystemDirectory(sourceDirectory));
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public BUILDER setSourceDirectory(String sourceDirectoryPath) {
        this.setSourceDirectory(new File(sourceDirectoryPath));
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public Directory getSourceDirectory() throws IllegalStateException {
        if (this.sourceDirectory == null) {
            throw new IllegalStateException("Source directory required. Call " + this.getClass().getSimpleName() + ".setSourceDirectory()");
        }
        return this.sourceDirectory;
    }

    public BUILDER setDestinationDirectory(Directory destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public BUILDER setDestinationDirectory(File destinationDirectory) {
        this.setDestinationDirectory(new FileSystemDirectory(destinationDirectory));
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public BUILDER setDestinationDirectory(String destinationDirectoryPath) {
        this.setDestinationDirectory(new File(destinationDirectoryPath));
        return (BUILDER)((BaseSiteMeshOfflineBuilder)this.self());
    }

    public Directory getDestinationDirectory() throws IllegalStateException {
        if (this.destinationDirectory == null) {
            throw new IllegalStateException("Destination directory required. Call " + this.getClass().getSimpleName() + ".setDestinationDirectory()");
        }
        return this.destinationDirectory;
    }
}

