/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.sitemesh.builder.BaseSiteMeshBuilder;
import org.sitemesh.config.PathMapper;
import org.sitemesh.webapp.WebAppContext;
import org.sitemesh.webapp.contentfilter.BasicSelector;
import org.sitemesh.webapp.contentfilter.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSiteMeshFilterBuilder<BUILDER extends BaseSiteMeshBuilder>
extends BaseSiteMeshBuilder<BUILDER, WebAppContext, Filter> {
    private Collection<String> mimeTypes;
    private PathMapper<Boolean> excludesMapper = new PathMapper();
    private Selector customSelector;

    @Override
    public abstract Filter create();

    @Override
    protected void setupDefaults() {
        super.setupDefaults();
        this.setMimeTypes("text/html");
    }

    public BUILDER addExcludedPath(String exclude) {
        this.excludesMapper.put(exclude, true);
        return this.self();
    }

    public BUILDER setMimeTypes(String ... mimeTypes) {
        this.mimeTypes = Arrays.asList(mimeTypes);
        return this.self();
    }

    public BUILDER setMimeTypes(List<String> mimeTypes) {
        this.mimeTypes = mimeTypes;
        return this.self();
    }

    public BUILDER setCustomSelector(Selector selector) {
        this.customSelector = selector;
        return this.self();
    }

    public Selector getSelector() {
        if (this.customSelector != null) {
            return this.customSelector;
        }
        String[] mimeTypesArray = this.mimeTypes.toArray(new String[this.mimeTypes.size()]);
        return new BasicSelector(mimeTypesArray){

            public boolean shouldBufferForRequest(HttpServletRequest request) {
                String requestPath = WebAppContext.getRequestPath(request);
                return super.shouldBufferForRequest(request) && BaseSiteMeshFilterBuilder.this.excludesMapper.get(requestPath) == null;
            }
        };
    }
}

