/*
 * Decompiled with CFR 0.152.
 */
package org.sitemesh.ant;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.sitemesh.ant.SiteMeshFileSet;
import org.sitemesh.builder.SiteMeshOfflineBuilder;
import org.sitemesh.config.ObjectFactory;
import org.sitemesh.config.xml.XmlOfflineConfigurator;
import org.sitemesh.offline.SiteMeshOffline;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteMeshTask
extends MatchingTask {
    private File destDir;
    private File config;
    private File srcdir;
    private List<FileSet> resources = new LinkedList<FileSet>();

    public void execute() throws BuildException {
        this.verify();
        List<FileSet> implicitFileSet = this.getImplicitAndExplicitFileSet();
        this.processFileSet(implicitFileSet);
    }

    protected List<FileSet> getImplicitAndExplicitFileSet() {
        Vector<FileSet> vfss = new Vector<FileSet>();
        FileSet fs = (FileSet)this.getImplicitFileSet().clone();
        if (this.srcdir != null) {
            fs.setDir(this.srcdir);
        }
        if (fs.getDir() != null) {
            vfss.addElement(fs);
        }
        for (FileSet rc : this.resources) {
            this.log("Adding FileSet to the list of FileSets to be processed " + rc.getDescription());
            vfss.addElement(rc);
        }
        return vfss;
    }

    protected void verify() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("dest not specified");
        }
    }

    protected void processFileSet(List<FileSet> filesets) {
        for (FileSet fileset : filesets) {
            DirectoryScanner directoryScanner = fileset.getDirectoryScanner(this.getProject());
            directoryScanner.setBasedir(fileset.getDir(this.getProject()));
            for (String path : directoryScanner.getIncludedFiles()) {
                SiteMeshOffline siteMeshOffline = this.createSiteMeshOffline(fileset);
                try {
                    this.log("Processing '" + path + "'");
                    siteMeshOffline.process(path);
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        }
    }

    protected SiteMeshOffline createSiteMeshOffline(FileSet fileset) {
        File destintationDir = this.destDir;
        SiteMeshOfflineBuilder builder = new SiteMeshOfflineBuilder();
        if (this.isSiteMeshFileSet(fileset)) {
            SiteMeshFileSet sfs = (SiteMeshFileSet)fileset;
            if (this.hasDestdir(fileset)) {
                destintationDir = sfs.getDestdir();
            }
            if (sfs.hasDecorator()) {
                String[] includes;
                for (String include : includes = fileset.mergeIncludes(this.getProject())) {
                    builder.addDecoratorPath(include, sfs.getDecorator());
                }
            }
        }
        ((SiteMeshOfflineBuilder)builder.setSourceDirectory(fileset.getDir())).setDestinationDirectory(destintationDir);
        if (this.isSiteMeshFileSetWithoutDecorator(fileset) || this.config != null) {
            new XmlOfflineConfigurator(new ObjectFactory.Default(), this.parseSiteMeshXmlConfig(this.config)).configureOffline(builder);
        }
        this.applyCustomConfiguration(builder);
        return builder.create();
    }

    protected boolean isSiteMeshFileSetWithoutDecorator(FileSet fileset) {
        return this.isSiteMeshFileSet(fileset) && !((SiteMeshFileSet)fileset).hasDecorator();
    }

    protected boolean hasDestdir(FileSet fileset) {
        return this.isSiteMeshFileSet(fileset) && ((SiteMeshFileSet)fileset).hasDestdir();
    }

    protected boolean isSiteMeshFileSet(FileSet fileset) {
        return fileset instanceof SiteMeshFileSet;
    }

    protected Element parseSiteMeshXmlConfig(File config) throws BuildException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(config).getDocumentElement();
        }
        catch (Exception e) {
            throw new BuildException("Could not parse " + config.getAbsolutePath() + " : " + e.getMessage(), (Throwable)e);
        }
    }

    protected void applyCustomConfiguration(SiteMeshOfflineBuilder builder) {
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setSrcdir(File srcDir) {
        this.srcdir = srcDir;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public void addSiteMeshfileset(SiteMeshFileSet fileset) {
        this.resources.add(fileset);
    }
}

