/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_dependency;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org_scala_tools_maven.VersionNumber;
import org_scala_tools_maven_dependency.ScalaConstants;
import org_scala_tools_maven_dependency.StringUtil;

public class CheckScalaVersionVisitor
implements DependencyNodeVisitor {
    private VersionNumber _version;
    private boolean _failed = false;
    private Log _log;
    private List<String> scalaDependentArtifactStrings = new ArrayList<String>();

    public boolean endVisit(DependencyNode node) {
        return !this._failed;
    }

    public CheckScalaVersionVisitor(String projectVerison, Log log) {
        this._version = new VersionNumber(projectVerison);
        this._log = log;
    }

    public boolean isScalaDistroArtifact(Artifact artifact) {
        return "org.scala-lang".equalsIgnoreCase(artifact.getGroupId()) && ScalaConstants.SCALA_DISTRO_ARTIFACTS.contains(artifact.getArtifactId());
    }

    public boolean visit(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        this._log.debug((CharSequence)("checking [" + artifact + "] for scala version"));
        if (this.isScalaDistroArtifact(artifact) && artifact.getVersion() != null) {
            VersionNumber originalVersion = new VersionNumber(artifact.getVersion());
            if (originalVersion.compareTo(this._version) != 0) {
                this._failed = true;
            }
            if (node.getParent() != null) {
                Artifact parentArtifact = node.getParent().getArtifact();
                this.scalaDependentArtifactStrings.add(" " + StringUtil.makeArtifactNameString(parentArtifact) + " requires scala version: " + originalVersion);
            }
        }
        return !this._failed;
    }

    public boolean isFailed() {
        return this._failed;
    }

    public void logScalaDependents() {
        this._log.warn((CharSequence)(" Expected all dependencies to require Scala version: " + this._version));
        for (String dependString : this.scalaDependentArtifactStrings) {
            this._log.warn((CharSequence)dependString);
        }
    }
}

