/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_dependency;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org_scala_tools_maven.VersionNumber;
import org_scala_tools_maven_dependency.ScalaConstants;

public class CheckScalaVersionVisitor
implements DependencyNodeVisitor {
    private VersionNumber _version;
    private boolean _failed = false;
    private Log _log;

    public boolean endVisit(DependencyNode node) {
        return !this._failed;
    }

    public CheckScalaVersionVisitor(String projectVerison, Log log) {
        this._version = new VersionNumber(projectVerison);
        this._log = log;
    }

    public boolean isScalaDistroArtifact(Artifact artifact) {
        return "org.scala-lang".equalsIgnoreCase(artifact.getGroupId()) && ScalaConstants.SCALA_DISTRO_ARTIFACTS.contains(artifact.getArtifactId());
    }

    public boolean visit(DependencyNode node) {
        VersionNumber originalVersion;
        Artifact artifact = node.getArtifact();
        this._log.debug((CharSequence)("checking [" + artifact + "] for scala version"));
        if (this.isScalaDistroArtifact(artifact) && artifact.getVersion() != null && (originalVersion = new VersionNumber(artifact.getVersion())).compareTo(this._version) != 0) {
            this._failed = true;
        }
        return !this._failed;
    }

    public boolean isFailed() {
        return this._failed;
    }
}

