/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.yaml.snakeyaml.Yaml;
import org_scala_tools_maven.ScalaMojoSupport;
import org_scala_tools_maven_executions.JavaMainCallerByFork;
import org_scala_tools_maven_executions.MainHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaToolsServerInitMojo
extends ScalaMojoSupport {
    protected String stsVersion = "0.1-SNAPSHOT";
    protected File outputDir;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    protected File sourceDir;
    protected File testOutputDir;
    protected File testSourceDir;

    @Override
    protected void doExecute() throws Exception {
        System.out.println(this.sendRequestAdd());
        System.out.println(this.sendRequestCompile());
    }

    private String toYaml(MavenProject project) throws Exception {
        HashMap<String, Object> dataCompile = new HashMap<String, Object>();
        dataCompile.put("name", project.getArtifactId() + "-" + project.getVersion() + "/main");
        dataCompile.put("sourcesDirs", this.getSourceDirectories());
        if (this.includes != null) {
            dataCompile.put("includes", new ArrayList<String>(this.includes));
        }
        if (this.excludes != null) {
            dataCompile.put("excludes", new ArrayList<String>(this.excludes));
        }
        dataCompile.put("targetDir", this.outputDir.getCanonicalPath());
        dataCompile.put("classpath", project.getCompileClasspathElements());
        if (this.args != null) {
            dataCompile.put("args", this.args);
        }
        dataCompile.put("dependency-link-path", this.localRepo.pathOf(project.getArtifact()));
        HashMap<String, Object> dataTest = new HashMap<String, Object>();
        dataTest.put("name", project.getArtifactId() + "-" + project.getVersion() + "/test");
        dataTest.put("sourcesDirs", project.getTestCompileSourceRoots());
        if (this.includes != null) {
            dataTest.put("includes", new ArrayList<String>(this.includes));
        }
        if (this.excludes != null) {
            dataTest.put("excludes", new ArrayList<String>(this.excludes));
        }
        dataTest.put("targetDir", this.testOutputDir.getCanonicalPath());
        dataTest.put("classpath", project.getTestClasspathElements());
        if (this.args != null) {
            dataTest.put("args", this.args);
        }
        Yaml yaml = new Yaml();
        return yaml.dump(dataCompile) + "/n---/n" + yaml.dump(dataTest);
    }

    protected List<String> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        List sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = this.sourceDir.getCanonicalPath())) {
            sources.add(scalaSourceDir);
        }
        return sources;
    }

    protected String sendRequestAdd() throws Exception {
        String yamlDef = this.toYaml(this.project);
        String back = "";
        try {
            back = this.sendRequest("add", yamlDef);
        }
        catch (ConnectException exc) {
            this.startNewServer();
            back = this.sendRequest("add", yamlDef);
        }
        return back;
    }

    protected String sendRequestCompile() throws Exception {
        return this.sendRequest("compile", null);
    }

    protected String sendRequestStop() throws Exception {
        return this.sendRequest("stop", null);
    }

    protected String sendRequest(String action, String data) throws Exception {
        URL url = new URL("http://127.0.0.1:27616/" + action);
        URLConnection cnx = url.openConnection();
        cnx.setDoOutput(StringUtils.isNotEmpty((String)data));
        cnx.setDoInput(true);
        if (StringUtils.isNotEmpty((String)data)) {
            IOUtil.copy((String)data, (OutputStream)cnx.getOutputStream());
            IOUtil.close((OutputStream)cnx.getOutputStream());
        }
        String back = IOUtil.toString((InputStream)cnx.getInputStream());
        IOUtil.close((InputStream)cnx.getInputStream());
        return back;
    }

    private void startNewServer() throws Exception {
        this.getLog().info((CharSequence)"start scala-tools-server...");
        HashSet<String> classpath = new HashSet<String>();
        this.addToClasspath("org.scala-lang", "scala-compiler", this.scalaVersion, classpath);
        this.addToClasspath("org.scala-tools", "scala-tools-server", this.stsVersion, classpath);
        JavaMainCallerByFork jcmd = new JavaMainCallerByFork(this, "org.scala_tools.server.HttpServer", MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()])), null, null, this.forceUseArgFile);
        jcmd.spawn(this.displayCmd);
        boolean started = false;
        while (!started) {
            try {
                System.out.print(".");
                Thread.sleep(1000L);
                this.sendRequest("ping", null);
                started = true;
                System.out.println("\n started");
            }
            catch (ConnectException exc) {
                started = false;
            }
        }
    }
}

