/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.redisson.RedissonMap;
import org.redisson.api.RMapReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.ScanCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import org.redisson.reactive.RedissonMapReactiveIterator;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.rx.Streams;

public class RedissonMapReactive<K, V>
extends RedissonExpirableReactive
implements RMapReactive<K, V> {
    private final RedissonMap<K, V> instance;

    public RedissonMapReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonMap(this.codec, commandExecutor, name);
    }

    public RedissonMapReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonMap(codec, commandExecutor, name);
    }

    @Override
    public Publisher<Integer> size() {
        return this.reactive(this.instance.sizeAsync());
    }

    @Override
    public Publisher<Boolean> containsKey(Object key) {
        return this.reactive(this.instance.containsKeyAsync(key));
    }

    @Override
    public Publisher<Boolean> containsValue(Object value) {
        return this.reactive(this.instance.containsValueAsync(value));
    }

    @Override
    public Publisher<Map<K, V>> getAll(Set<K> keys) {
        return this.reactive(this.instance.getAllAsync(keys));
    }

    @Override
    public Publisher<Void> putAll(Map<? extends K, ? extends V> map) {
        return this.reactive(this.instance.putAllAsync(map));
    }

    @Override
    public Publisher<V> putIfAbsent(K key, V value) {
        return this.reactive(this.instance.putIfAbsentAsync(key, value));
    }

    @Override
    public Publisher<Boolean> remove(Object key, Object value) {
        return this.reactive(this.instance.removeAsync(key, value));
    }

    @Override
    public Publisher<Boolean> replace(K key, V oldValue, V newValue) {
        return this.reactive(this.instance.replaceAsync(key, oldValue, newValue));
    }

    @Override
    public Publisher<V> replace(K key, V value) {
        return this.reactive(this.instance.replaceAsync(key, value));
    }

    @Override
    public Publisher<V> get(K key) {
        return this.reactive(this.instance.getAsync(key));
    }

    @Override
    public Publisher<V> put(K key, V value) {
        return this.reactive(this.instance.putAsync(key, value));
    }

    @Override
    public Publisher<V> remove(K key) {
        return this.reactive(this.instance.removeAsync(key));
    }

    @Override
    public Publisher<Boolean> fastPut(K key, V value) {
        return this.reactive(this.instance.fastPutAsync(key, value));
    }

    @Override
    public Publisher<Long> fastRemove(K ... keys) {
        return this.reactive(this.instance.fastRemoveAsync(keys));
    }

    Publisher<MapScanResult<ScanObjectEntry, ScanObjectEntry>> scanIteratorReactive(InetSocketAddress client, long startPos) {
        return this.commandExecutor.readReactive(client, this.getName(), new ScanCodec(this.codec), RedisCommands.HSCAN, this.getName(), startPos);
    }

    @Override
    public Publisher<Map.Entry<K, V>> entryIterator() {
        return new RedissonMapReactiveIterator(this).stream();
    }

    @Override
    public Publisher<V> valueIterator() {
        return new RedissonMapReactiveIterator<K, V, V>(this){

            @Override
            V getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getValue().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<K> keyIterator() {
        return new RedissonMapReactiveIterator<K, V, K>(this){

            @Override
            K getValue(Map.Entry<ScanObjectEntry, ScanObjectEntry> entry) {
                return entry.getKey().getObj();
            }
        }.stream();
    }

    @Override
    public Publisher<V> addAndGet(K key, Number value) {
        return this.reactive(this.instance.addAndGetAsync(key, value));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.size() != ((Integer)Streams.create(this.size()).next().poll()).intValue()) {
                return false;
            }
            return (Boolean)Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).next().poll();
        }
        if (o instanceof RMapReactive) {
            RMapReactive m = (RMapReactive)o;
            if (Streams.create(m.size()).next().poll() != Streams.create(this.size()).next().poll()) {
                return false;
            }
            return (Boolean)Streams.create(this.entryIterator()).map(this.mapFunction(m)).reduce((Object)true, this.booleanAnd()).next().poll();
        }
        return true;
    }

    private BiFunction<Boolean, Boolean, Boolean> booleanAnd() {
        return new BiFunction<Boolean, Boolean, Boolean>(){

            public Boolean apply(Boolean t, Boolean u) {
                return t & u;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final Map<?, ?> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key))) {
                    return false;
                }
                return true;
            }
        };
    }

    private Function<Map.Entry<K, V>, Boolean> mapFunction(final RMapReactive<Object, Object> m) {
        return new Function<Map.Entry<K, V>, Boolean>(){

            public Boolean apply(Map.Entry<K, V> e) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null ? Streams.create(m.get(key)).next().poll() != null || (Boolean)Streams.create(m.containsKey(key)).next().poll() == false : !value.equals(Streams.create(m.get(key)).next().poll())) {
                    return false;
                }
                return true;
            }
        };
    }

    public int hashCode() {
        return (Integer)Streams.create(this.entryIterator()).map(new Function<Map.Entry<K, V>, Integer>(){

            public Integer apply(Map.Entry<K, V> t) {
                return t.hashCode();
            }
        }).reduce((Object)0, (BiFunction)new BiFunction<Integer, Integer, Integer>(){

            public Integer apply(Integer t, Integer u) {
                return t + u;
            }
        }).next().poll();
    }
}

