/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.Collections;
import org.reactivestreams.Publisher;
import org.redisson.api.RAtomicLongReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.SingleConvertor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;
import reactor.rx.Streams;

public class RedissonAtomicLongReactive
extends RedissonExpirableReactive
implements RAtomicLongReactive {
    public RedissonAtomicLongReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public Publisher<Long> addAndGet(long delta) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCRBY, this.getName(), delta);
    }

    @Override
    public Publisher<Boolean> compareAndSet(long expect, long update) {
        return this.commandExecutor.evalWriteReactive(this.getName(), StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getName()), expect, update);
    }

    @Override
    public Publisher<Long> decrementAndGet() {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.DECR, this.getName());
    }

    @Override
    public Publisher<Long> get() {
        return this.addAndGet(0L);
    }

    @Override
    public Publisher<Long> getAndAdd(final long delta) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, new RedisStrictCommand<Long>("INCRBY", (Convertor<Long>)new SingleConvertor<Long>(){

            @Override
            public Long convert(Object obj) {
                return (Long)obj - delta;
            }
        }), this.getName(), delta);
    }

    @Override
    public Publisher<Long> getAndSet(long newValue) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GETSET, this.getName(), newValue);
    }

    @Override
    public Publisher<Long> incrementAndGet() {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.INCR, this.getName());
    }

    @Override
    public Publisher<Long> getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public Publisher<Long> getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    @Override
    public Publisher<Void> set(long newValue) {
        return this.commandExecutor.writeReactive(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET, this.getName(), newValue);
    }

    public String toString() {
        return Long.toString((Long)Streams.create(this.get()).next().poll());
    }
}

