/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.api.RFuture;
import reactor.core.support.Exceptions;
import reactor.rx.Stream;
import reactor.rx.action.Action;
import reactor.rx.subscription.ReactiveSubscription;

public class NettyFuturePublisher<T>
extends Stream<T> {
    private final RFuture<? extends T> that;

    public NettyFuturePublisher(RFuture<? extends T> that) {
        this.that = that;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe((Subscription)new ReactiveSubscription<T>(this, subscriber){

                public void request(long elements) {
                    Action.checkRequest((long)elements);
                    if (this.isComplete()) {
                        return;
                    }
                    NettyFuturePublisher.this.that.addListener(new FutureListener<T>(){

                        public void operationComplete(Future<T> future) throws Exception {
                            if (!future.isSuccess()) {
                                subscriber.onError(future.cause());
                                return;
                            }
                            if (future.getNow() != null) {
                                subscriber.onNext(future.getNow());
                            }
                            this.onComplete();
                        }
                    });
                }
            });
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal((Throwable)throwable);
            subscriber.onError(throwable);
        }
    }
}

