/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.jcache;

import javax.cache.processor.MutableEntry;
import org.redisson.jcache.JCache;

public class JMutableEntry<K, V>
implements MutableEntry<K, V> {
    final JCache<K, V> jCache;
    final K key;
    boolean isReadThrough;
    Action action = Action.SKIPPED;
    V value;

    public JMutableEntry(JCache<K, V> jCache, V value, K key, boolean isReadThrough) {
        this.jCache = jCache;
        this.value = value;
        this.key = key;
        this.isReadThrough = isReadThrough;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        if (this.action != Action.SKIPPED) {
            return this.value;
        }
        if (this.value != null) {
            this.action = Action.READ;
        } else if (this.isReadThrough) {
            this.value = this.jCache.load(this.key);
            if (this.value != null) {
                this.action = Action.LOADED;
            }
            this.isReadThrough = false;
        }
        return this.value;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this;
    }

    public boolean exists() {
        return this.getValue() != null;
    }

    public void remove() {
        this.action = this.action == Action.CREATED ? Action.SKIPPED : Action.DELETED;
        this.value = null;
    }

    public void setValue(V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.action != Action.CREATED) {
            this.action = this.exists() ? Action.UPDATED : Action.CREATED;
        }
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        CREATED,
        READ,
        UPDATED,
        DELETED,
        LOADED,
        SKIPPED;

    }
}

