/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.connection.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueTransferTask {
    private static final Logger log = LoggerFactory.getLogger(QueueTransferTask.class);
    private int usage = 1;
    private final AtomicReference<Timeout> timeoutReference = new AtomicReference();
    private final ConnectionManager connectionManager;
    private int messageListenerId;
    private int statusListenerId;

    public QueueTransferTask(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void incUsage() {
        ++this.usage;
    }

    public int decUsage() {
        --this.usage;
        return this.usage;
    }

    public void start() {
        RTopic<Long> schedulerTopic = this.getTopic();
        this.statusListenerId = schedulerTopic.addListener(new BaseStatusListener(){

            @Override
            public void onSubscribe(String channel) {
                QueueTransferTask.this.pushTask();
            }
        });
        this.messageListenerId = schedulerTopic.addListener(new MessageListener<Long>(){

            @Override
            public void onMessage(String channel, Long startTime) {
                QueueTransferTask.this.scheduleTask(startTime);
            }
        });
    }

    public void stop() {
        RTopic<Long> schedulerTopic = this.getTopic();
        schedulerTopic.removeListener(this.messageListenerId);
        schedulerTopic.removeListener(this.statusListenerId);
    }

    private void scheduleTask(Long startTime) {
        long delay;
        if (startTime == null) {
            return;
        }
        Timeout oldTimeout = this.timeoutReference.get();
        if (oldTimeout != null) {
            oldTimeout.cancel();
            this.timeoutReference.compareAndSet(oldTimeout, null);
        }
        if ((delay = startTime - System.currentTimeMillis()) > 10L) {
            Timeout timeout = this.connectionManager.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    QueueTransferTask.this.pushTask();
                }
            }, delay, TimeUnit.MILLISECONDS);
            this.timeoutReference.set(timeout);
        } else {
            this.pushTask();
        }
    }

    protected abstract RTopic<Long> getTopic();

    protected abstract RFuture<Long> pushTaskAsync();

    private void pushTask() {
        RFuture<Long> startTimeFuture = this.pushTaskAsync();
        this.addListener(startTimeFuture);
    }

    private void addListener(RFuture<Long> startTimeFuture) {
        startTimeFuture.addListener(new FutureListener<Long>(){

            public void operationComplete(Future<Long> future) throws Exception {
                if (!future.isSuccess()) {
                    if (future.cause() instanceof RedissonShutdownException) {
                        return;
                    }
                    log.error(future.cause().getMessage(), future.cause());
                    QueueTransferTask.this.scheduleTask(System.currentTimeMillis() + 5000L);
                    return;
                }
                if (future.getNow() != null) {
                    QueueTransferTask.this.scheduleTask((Long)future.getNow());
                }
            }
        });
    }
}

