/*
 * Decompiled with CFR 0.152.
 */
package org.red5.server;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.red5.classloading.ClassLoaderBuilder;

public class Bootstrap {
    public static void main(String[] args) throws Exception {
        try {
            String root = Bootstrap.getRed5Root();
            Bootstrap.getConfigurationRoot(root);
            Bootstrap.bootStrap();
            System.out.println("Bootstrap complete");
        }
        catch (Throwable t) {
            System.out.printf("Bootstrap exception: %s%n", t.getMessage());
            t.printStackTrace();
        }
        finally {
            System.out.println("Bootstrap exit");
        }
    }

    private static void bootStrap() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String os;
        System.setProperty("red5.deployment.type", "bootstrap");
        System.setProperty("sun.lang.ClassLoader.allowArraySyntax", "true");
        String policyFile = System.getProperty("java.security.policy");
        if (policyFile == null) {
            System.setProperty("java.security.debug", "all");
            System.setProperty("java.security.policy", String.format("%s/red5.policy", System.getProperty("red5.config_root")));
        }
        if ((os = System.getProperty("os.name").toLowerCase()).contains("vista") || os.contains("windows 7")) {
            String dir = System.getProperty("user.home");
            if (dir.length() == 3) {
                File f = new File(dir = dir + "Users\\Default\\AppData\\Red5");
                if (!f.exists()) {
                    f.mkdir();
                }
                f = null;
            } else {
                dir = dir + "\\AppData\\localLow";
            }
            System.setProperty("java.io.tmpdir", dir);
            System.out.printf("Setting temp directory to %s%n", System.getProperty("java.io.tmpdir"));
        }
        ClassLoader baseLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ClassLoaderBuilder.build();
        Thread.currentThread().setContextClassLoader(loader);
        Object boot = Class.forName("org.red5.server.Launcher", true, loader).newInstance();
        Method m1 = boot.getClass().getMethod("launch", null);
        m1.invoke(boot, (Object[])null);
        Thread.currentThread().setContextClassLoader(baseLoader);
    }

    static String getConfigurationRoot(String root) {
        String conf = System.getProperty("red5.config_root");
        if (root != null && conf == null) {
            conf = root + "/conf";
        }
        if (File.separatorChar != '/') {
            conf = conf.replaceAll("\\\\", "/");
        }
        System.setProperty("red5.config_root", conf);
        System.out.printf("Configuation root: %s%n", conf);
        return conf;
    }

    static String getRed5Root() throws IOException {
        String root = System.getProperty("red5.root");
        if (root == null) {
            root = System.getenv("RED5_HOME");
        }
        if (root == null || ".".equals(root)) {
            root = System.getProperty("user.dir");
        }
        if (File.separatorChar != '/') {
            root = root.replaceAll("\\\\", "/");
        }
        if (root.charAt(root.length() - 1) == '/') {
            root = root.substring(0, root.length() - 1);
        }
        System.setProperty("red5.root", root);
        System.out.printf("Red5 root: %s%n", root);
        return root;
    }
}

